<?php

declare(strict_types=1);

class MyvetshopCliniqueShipping extends ObjectModel
{
    public const TABLE = 'myvetshop_clinique_shipping';

    public $id_myvetshop_clinique;

    public $monday;

    public $tuesday;

    public $wednesday;

    public $thursday;

    public $friday;

    public $saturday;

    public $sunday;

    public static $definition = [
        'table' => self::TABLE,
        'primary' => 'id_myvetshop_clinique_shipping',
        'fields' => [
            'id_myvetshop_clinique' => ['type' => self::TYPE_INT, 'required' => true, 'validate' => 'isInt'],
            'monday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'tuesday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'wednesday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'thursday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'friday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'saturday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'sunday' => ['type' => self::TYPE_BOOL, 'required' => false],
        ],
    ];

    public function hasAllDaysDisable(): bool
    {
        $disable = true;

        foreach (self::getDays() as $day => $translate) {
            $disable = $disable && !$this->{$day};
        }

        return $disable;
    }

    public function getClinique(): Clinique
    {
        return new Clinique($this->id_myvetshop_clinique);
    }

    public static function getByCliniqueId(int $cliniqueId): self
    {
        $query = 'SELECT id_myvetshop_clinique_shipping FROM ' . _DB_PREFIX_ . self::$definition['table'] . ' WHERE id_myvetshop_clinique=' . $cliniqueId;
        $cliniqueShippingId = (int) Db::getInstance()->getValue($query);

        $cliniqueShipping = new self($cliniqueShippingId);

        if (!Validate::isLoadedObject($cliniqueShipping)) {
            $cliniqueShipping = new self();

            $cliniqueShipping->id_myvetshop_clinique = $cliniqueId;
            $cliniqueShipping->monday = false;
            $cliniqueShipping->tuesday = false;
            $cliniqueShipping->wednesday = false;
            $cliniqueShipping->thursday = false;
            $cliniqueShipping->friday = false;
            $cliniqueShipping->saturday = false;
            $cliniqueShipping->sunday = false;

            $cliniqueShipping->save();
        }

        return $cliniqueShipping;
    }

    public static function getDays(): array
    {
        return [
            'monday' => 'lundi',
            'tuesday' => 'mardi',
            'wednesday' => 'mercredi',
            'thursday' => 'jeudi',
            'friday' => 'vendredi',
            'saturday' => 'samedi',
            'sunday' => 'dimanche',
        ];
    }

    public static function getDay(string $day): string
    {
        $day = strtolower($day);
        $days = self::getDays();

        if (!array_key_exists($day, $days)) {
            throw new Exception(sprintf('Day %s does not exist', $day));
        }

        return $days[$day];
    }

    public function toArray(): array
    {
        return [
            'monday' => $this->monday,
            'tuesday' => $this->tuesday,
            'wednesday' => $this->wednesday,
            'thursday' => $this->thursday,
            'friday' => $this->friday,
            'saturday' => $this->saturday,
            'sunday' => $this->sunday,
        ];
    }

    public function toString(): string
    {
        return implode(',', array_filter(self::getDays(), fn ($day) => $this->{$day}, \ARRAY_FILTER_USE_KEY));
    }

    public static function install(): bool
    {
        $query = 'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . static::TABLE . '` (
              `id_myvetshop_clinique_shipping` INT(11) NOT NULL AUTO_INCREMENT,
              `id_myvetshop_clinique` INT(11) NOT NULL,
              `monday` TINYINT(1) DEFAULT 0,
              `tuesday` TINYINT(1) DEFAULT 0,
              `wednesday` TINYINT(1) DEFAULT 0,
              `thursday` TINYINT(1) DEFAULT 0,
              `friday` TINYINT(1) DEFAULT 0,
              `saturday` TINYINT(1) DEFAULT 0,
              `sunday` TINYINT(1) DEFAULT 0,
               PRIMARY KEY (`id_myvetshop_clinique_shipping`),
               INDEX (`id_myvetshop_clinique`)
            );';

        return Db::getInstance()->execute($query);
    }

    public function add($auto_date = true, $null_values = false)
    {
        return parent::add($auto_date, $null_values) && parent::update();
    }

    public function update($null_values = false)
    {
        $result = parent::update($null_values);

        $this->getClinique()->update();

        return $result;
    }
}
