<?php

declare(strict_types=1);

class ProductApi
{
    /**
     * @var Context
     */
    private $context;

    public function __construct(Context $context)
    {
        $this->context = $context;
    }

    /**
     * @return array<string, mixed>
     */
    private function serializeProduct(Product $product): array
    {
        $images = $product->getImages($this->context->language->id);
        $images_urls = [
            'cart_default' => [],
            'home_default' => [],
            'large_default' => [],
        ];

        foreach ($images as $image) {
            foreach ($images_urls as $size => $values) {
                $images_urls[$size][] = (new Link('https://', 'https://'))->getImageLink($product->link_rewrite[$this->context->language->id], $image['id_image'], $size);
            }
        }

        return [
            'id' => $product->id,
            'name' => $product->name[$this->context->language->id],
            'link' => $product->getLink($this->context),
            'images' => $images_urls,
        ];
    }

    /**
     * @return array<string, mixed>
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function actionGet(int $productId): array
    {
        return $this->serializeProduct(new Product($productId));
    }
}
