<?php

// Si on est pas exécuté depuis la ligne de commande, ou si la mauvaise secure_key est envoyée, on arrête tout !
if (php_sapi_name() != "cli") {
    die(1);
}

// Désactivation du timeout
set_time_limit(0);


/////////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once(dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'config' . DIRECTORY_SEPARATOR . 'config.inc.php');

    // Gestion multi-boutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit();
}

$context = Context::getContext();

// Workaround pour PrestaShop
$context->controller = (object)[
    'controller_type' => 'cron',
];

/////////////////////////////////////////////////
/// Classes spécifiques
require_once __DIR__ . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'Animal.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'AnimalSac.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . 'classes' . DIRECTORY_SEPARATOR . 'CustomerPush.php';
require_once __DIR__ . DIRECTORY_SEPARATOR . 'class' . DIRECTORY_SEPARATOR . 'NotificationManager.php';

$db = Db::getInstance();

$notificationManager = new NotificationManager();

$animal = new Animal(2);

// Récupère les identifiants PUSH pour cet animal
/** @var CustomerPush[] $customerPushes */
$customerPushes = ObjectModel::hydrateCollection(
    CustomerPush::class,
    $db->executeS(
        'SELECT `cp`.*'
        . ' FROM `ps_customer_push` `cp`'
        . ' INNER JOIN `ps_oauth_access_token` `oat` ON `oat`.`id_oauth_access_token` =  `cp`.`id_oauth_access_token`'
        . ' WHERE `cp`.`id_customer` = ' . (int)$animal->id_customer
        . ' AND `cp`.`deleted` = 0'
        . ' AND `oat`.`expires` >= ' . time() . ' '
    )
);

foreach ($customerPushes as $customerPush) {
    try {
        if ($animal->espece == 'chat') {
            $notificationManager->sendNotification(
                $customerPush,
                mb_convert_encoding("&#128049; MIAOU ! " . trim($animal->nom) . " va avoir besoin d'un nouveau sac de croquettes !\nCliquez ici pour commander", 'UTF-8', 'HTML-ENTITIES')
            );
        } elseif ($animal->espece == 'chien') {
            $notificationManager->sendNotification(
                $customerPush,
                mb_convert_encoding("&#128054; WOOF ! " . trim($animal->nom) . " va avoir besoin d'un nouveau sac de croquettes !\nCliquez ici pour commander", 'UTF-8', 'HTML-ENTITIES')
            );
        } else {
            $notificationManager->sendNotification($customerPush, trim($animal->nom) . " va avoir besoin d'un nouveau sac de croquettes !\nCliquez ici pour commander");
        }
    } catch (\GuzzleHttp\Exception\GuzzleException $e) {
        // Inhibiteur d'erreur
    }
}