<?php

declare(strict_types=1);

/**
 * Class AdminMyVetShopVeterinaireController.
 *
 * @property MyvetshopVeterinaire $object
 */
class AdminMyVetShopVeterinaireController extends ModuleAdminController
{
    /**
     * @var Clinique
     */
    private $clinique;

    public function __construct()
    {
        parent::__construct();

        $this->bootstrap = true;
        $this->context = Context::getContext();
        $this->table = MyvetshopVeterinaire::$definition['table'];
        $this->className = MyvetshopVeterinaire::class;
        $this->position_identifier = MyvetshopVeterinaire::$definition['primary'];
        $this->identifier = MyvetshopVeterinaire::$definition['primary'];
        $this->_orderBy = MyvetshopVeterinaire::$definition['primary'];

        $this->clinique = new Clinique(Tools::getValue('id_myvetshop_clinique'));

        if (!Validate::isLoadedObject($this->clinique)) {
            $this->loadObject();

            if (!Validate::isLoadedObject($this->object)) {
                Tools::redirectAdmin($this->context->link->getAdminLink('AdminMyVetShopClinique'));
            }

            $this->clinique = $this->object->getClinique();
        }

        $this->_where = 'AND id_myvetshop_clinique=' . $this->clinique->id;

        $this->page_header_toolbar_title = $this->clinique->name;

        $this->fields_list = [
            'id_myvetshop_veterinaire' => [
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs',
            ],
            'lastname' => [
                'title' => $this->l('Nom'),
            ],
            'firstname' => [
                'title' => $this->l('Prénom'),
            ],
            'url_teleconsultation' => [
                'title' => $this->l('Url de téléconsultation'),
            ],
        ];

        $this->addRowAction('edit');
        $this->addRowAction('delete');
    }

    public function initToolbar(): void
    {
        parent::initToolbar();

        if (isset($this->toolbar_btn['new'])) {
            $this->toolbar_btn['new']['href'] = $this->context->link->getAdminLink('AdminMyVetShopVeterinaire') . '&addmyvetshop_veterinaire&id_myvetshop_clinique=' . $this->clinique->id;
        }
    }

    public function initPageHeaderToolbar(): void
    {
        parent::initPageHeaderToolbar();

        $this->page_header_toolbar_btn['clinique'] = [
            'href' => $this->context->link->getAdminLink('AdminMyVetShopClinique'),
            'desc' => $this->l('Retour aux cliniques'),
            'icon' => 'process-icon-back',
        ];
    }

    public function renderForm()
    {
        $this->fields_form = [
            'legend' => [
                'title' => Validate::isLoadedObject($this->object) ? $this->l('Modifier un vétérinaire') : $this->l('Ajouter un vétérinaire'),
                'icon' => 'icon-angle-double-right',
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => $this->l('Prénom'),
                    'name' => 'firstname',
                    'required' => false,
                    'col' => '2',
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('Nom'),
                    'name' => 'lastname',
                    'required' => false,
                    'col' => '2',
                ],
                [
                    'type' => 'text',
                    'label' => $this->l('URL Téléconsultation'),
                    'name' => 'url_teleconsultation',
                    'required' => false,
                    'col' => '6',
                ],
                [
                    'name' => 'id_myvetshop_clinique',
                    'type' => 'hidden',
                ],
            ],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right',
                'name' => 'saveAction',
            ],
        ];

        if (!Validate::isLoadedObject($this->object)) {
            $this->fields_value = [
                'id_myvetshop_clinique' => $this->clinique->id,
            ];
        }

        return parent::renderForm();
    }

    /**
     * @param MyvetshopVeterinaire $object
     *
     * @return bool|void
     *
     * @throws PrestaShopException
     */
    public function afterAdd($object)
    {
        $this->redirect_after = $this->context->link->getAdminLink('AdminMyVetShopVeterinaire') . '&id_myvetshop_clinique=' . $object->id_myvetshop_clinique;
    }

    public function afterUpdate($object)
    {
        return parent::afterAdd($object);
    }

    public function processDelete()
    {
        $object = parent::processDelete();

        $this->afterAdd($object);

        return $object;
    }
}
