<?php

declare(strict_types=1);

/**
 * @property MyVetshopClinique $module
 */
class AdminMyVetShopThemeController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();

        $this->bootstrap = true;
        $this->context = Context::getContext();
        $this->table = MyvetshopTheme::$definition['table'];
        $this->className = MyvetshopTheme::class;
        $this->position_identifier = MyvetshopTheme::$definition['primary'];
        $this->identifier = MyvetshopTheme::$definition['primary'];
        $this->_orderBy = MyvetshopTheme::$definition['primary'];

        $this->fields_list = [
            'id_myvetshop_theme' => [
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs',
            ],
            'name' => [
                'title' => $this->l('Nom du thème'),
            ],
        ];

        $this->addRowAction('edit');
        $this->addRowAction('delete');
    }

    public function initPageHeaderToolbar(): void
    {
        parent::initPageHeaderToolbar();

        $this->page_header_toolbar_btn['reload'] = [
            'href' => $this->context->link->getAdminLink('AdminMyVetShopTheme') . '&action=reloadCss',
            'desc' => $this->l('Recharger le css'),
            'icon' => 'process-icon-refresh',
        ];
    }

    public function renderForm()
    {
        $this->fields_form = [
            'legend' => [
                'title' => Validate::isLoadedObject($this->object) ? $this->l('Modifier un thème') : $this->l('Ajouter un thème'),
                'icon' => 'icon-angle-double-right',
            ],
            'input' => [
                [
                    'type' => 'text',
                    'label' => $this->l('Nom'),
                    'name' => 'name',
                    'required' => true,
                    'col' => '2',
                ],
                [
                    'type' => 'color',
                    'label' => $this->l('Couleur 1'),
                    'name' => 'color_1',
                    'required' => true,
                ],
                [
                    'type' => 'color',
                    'label' => $this->l('Couleur 2'),
                    'name' => 'color_2',
                    'required' => true,
                ],
                [
                    'type' => 'color',
                    'label' => $this->l('Couleur 3'),
                    'name' => 'color_3',
                    'required' => true,
                ],
                [
                    'type' => 'color',
                    'label' => $this->l('Couleur 4'),
                    'name' => 'color_4',
                    'required' => true,
                ],
                [
                    'type' => 'color',
                    'label' => $this->l('Couleur 5'),
                    'name' => 'color_5',
                    'required' => true,
                ],
            ],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right',
                'name' => 'saveAction',
            ],
        ];

        return parent::renderForm();
    }

    public function processReloadCss(): void
    {
        // On lance un update pour déclencher le hook qui va rebuild le css
        foreach (MyvetshopTheme::getAll() as $theme) {
            $theme->update();
        }

        $this->confirmations[] = $this->l('Tous les fichiers css ont été généré');
    }
}
