<?php

declare(strict_types=1);

class WebserviceSpecificManagementFeatures implements WebserviceSpecificManagementInterface
{
    /** @var WebserviceOutputBuilderCore */
    protected $objOutput;

    /** @var mixed */
    protected $output;

    /** @var WebserviceRequestCore
     */
    protected $wsObject;

    public function setObjectOutput(WebserviceOutputBuilderCore $obj)
    {
        $this->objOutput = $obj;

        return $this;
    }

    public function getObjectOutput()
    {
        return $this->objOutput;
    }

    public function setWsObject(WebserviceRequestCore $obj)
    {
        $this->wsObject = $obj;

        return $this;
    }

    public function getWsObject()
    {
        return $this->wsObject;
    }

    public function manage(): void
    {
        header('Content-Type: application/json');

        if (!isset($this->wsObject->urlFragments['featureName'])) {
            http_response_code(400);
            echo json_encode(['error' => 'You have to set both the \'featureName\' parameters to get a result']);
            exit;
        }

        try {
            $listValueFeature = [];

            switch ($this->wsObject->urlFragments['featureName']) {
                case 'type':
                    $listValueFeature = $this->getValuesFeature('Type d\'alimentation');
                    break;

                case 'conditioning':
                    $listValueFeature = $this->getValuesFeature('Conditionnement');
                    break;

                case 'range':
                    $listValueFeature = $this->getValuesFeature('Gamme');
                    break;

                case 'disease':
                    $listValueFeature = $this->getValuesFeature('Maladie');
                    break;

                case 'supplier':
                    $listValueFeature = $this->getValuesFeature('Fournisseur');
                    break;

                case 'species':
                    $listValueFeature = $this->getValuesFeature('Espèces');
                    break;

                default:
                    http_response_code(400);
                    echo json_encode(['error' => 'Invalid feature name']);
                    exit;
            }

            echo json_encode($listValueFeature);
            exit;
        } catch (Exception $exception) {
            http_response_code(500);
            echo json_encode(['error' => $exception->getMessage()]);
            exit;
        }
    }

    /**
     * This must be return an array with specific values as WebserviceRequest expects.
     */
    public function getContent(): array
    {
        return $this->objOutput->getObjectRender()->overrideContent($this->output);
    }

    /**
     * @return array<string, mixed>
     *
     * @throws PrestaShopDatabaseException
     */
    private static function getValuesFeature(string $featureName): array
    {
        $db = Db::getInstance();

        $query = '
        SELECT feature_value.id_feature, feature_value_lang.value, feature_value.id_feature_value
        FROM `ps_feature_value` as feature_value
        INNER JOIN `ps_feature_lang` as feature_lang on feature_lang.id_feature =  feature_value.id_feature
        INNER JOIN `ps_feature_value_lang` as feature_value_lang on feature_value_lang.id_feature_value =  feature_value.id_feature_value
        WHERE feature_lang.name = "' . $db->escape($featureName) . '"
        ';

        $result = $db->executeS($query);

        if (!is_array($result)) {
            $result = [];
        }

        return $result;
    }
}
