<?php

declare(strict_types=1);

/**
 * Class UserProvider
 * Cette class retourne l'utilisateur connecté.
 */
class UserProvider
{
    /**
     * @return Customer|Employee
     *
     * @throws MvsUnauthorizedException
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function getUser(OAuthAccessToken $accessToken): object
    {
        $idEmployee = $accessToken->id_employee;
        $idCustomer = $accessToken->id_customer;

        $user = null;

        if ($idCustomer) {
            $user = new Customer($idCustomer);
        } elseif ($idEmployee) {
            $user = new Employee($idEmployee);
        }

        if (!$user || !$user->id) {
            throw new MvsUnauthorizedException();
        }

        return $user;
    }
}
