<?php

namespace Unit\Serializer;

use Myvetshop\Module\Clinique\Serializer\DiscountReportingSerializer;
use PHPUnit\Framework\TestCase;

class DiscountReportingSerializerTest extends TestCase
{
    public function testSerialize(): void
    {
        self::assertSame(
            [
                [
                    'id' => 1,
                    'code' => 'PROMO',
                    'name' => 'Ma super promo',
                    'products' => [
                        [
                            'id' => 1,
                            'name' => 'Chat Metabolic Poulet',
                            'category_id' => 4,
                            'manufacturer_id' => 5,
                        ],
                        [
                            'id' => 2,
                            'name' => 'Chien Metabolic Poulet',
                            'category_id' => 9,
                            'manufacturer_id' => 5,
                        ],
                    ],
                ],
            ],
            \json_decode(
                (new DiscountReportingSerializer())->serialize([
                    [
                        'id' => '1',
                        'code' => 'PROMO',
                        'name' => 'Ma super promo',
                        'products' => [
                            [
                                'id' => '1',
                                'name' => 'Chat Metabolic Poulet',
                                'category_id' => '4',
                                'manufacturer_id' => '5',
                            ],
                            [
                                'id' => '2',
                                'name' => 'Chien Metabolic Poulet',
                                'category_id' => '9',
                                'manufacturer_id' => '5',
                            ],
                        ],
                    ],
                ]),
                true,
            )
        );
    }
}
