<?php

namespace Unit\Import\Sync\Syncer;

use Myvetshop\Module\Clinique\Import\Model\CustomerModel;
use Myvetshop\Module\Clinique\Import\Sync\Syncer\CustomerSyncer;
use Myvetshop\Module\Clinique\Import\Sync\SyncStatistics;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class CustomerSyncerTest extends TestCase
{
    /**
     * @var CustomerSyncer&MockObject
     */
    private CustomerSyncer $customerSyncer;

    protected function createCustomerMock(): \Customer
    {
        $ret = $this->createMock(\Customer::class);

        $ret
            ->expects($this->atLeastOnce())
            ->method('save')
            ->willReturn(true);

        return $ret;
    }

    protected function setUp(): void
    {
        parent::setUp();
        $this->customerSyncer = $this->createPartialMock(
            CustomerSyncer::class,
            ['getCustomer', 'createCustomer']
        );
    }

    /**
     * Test sync method for basic functionality
     */
    public function testSync(): void
    {
        // Prepare our partial mock
        $this->customerSyncer
            ->method('getCustomer')
            ->willReturn(null);
        $this->customerSyncer
            ->method('createCustomer')
            ->willReturnCallback(fn (): \Customer => $this->createCustomerMock());

        $mockSyncStatistics = new SyncStatistics();
        $mockClinique = $this->createMock(\Clinique::class);

        $customerModel = new CustomerModel();
        $customerModel->idCustomer = 1;
        $customerModel->idShopGroup = 1;
        $customerModel->idShop = 1;
        $customerModel->idStore = 1;
        $customerModel->idGender = 1;
        $customerModel->idDefaultGroup = 1;
        $customerModel->idLang = 1;
        $customerModel->idRisk = 1;
        $customerModel->company = 'Test Company';
        $customerModel->siret = '123456789';
        $customerModel->ape = '1234A';
        $customerModel->firstname = 'Test';
        $customerModel->lastname = 'User';
        $customerModel->email = 'test.user@example.com';
        $customerModel->passwd = 'passw0rd';
        $customerModel->lastPasswdGen = new \DateTimeImmutable();
        $customerModel->birthday = '1990-01-01';
        $customerModel->newsletter = true;
        $customerModel->ipRegistrationNewsletter = '192.168.1.1';
        $customerModel->newsletterDateAdd = new \DateTimeImmutable();
        $customerModel->optin = true;
        $customerModel->website = 'www.test.com';
        $customerModel->outstandingAllowAmount = '1000';
        $customerModel->showPublicPrices = true;
        $customerModel->secureKey = 'secureKey123';
        $customerModel->note = 'Test Note';
        $customerModel->active = true;
        $customerModel->isGuest = false;
        $customerModel->deleted = false;
        $customerModel->dateAdd = new \DateTimeImmutable();
        $customerModel->dateUpd = new \DateTimeImmutable();

        // Call the function to test
        $resultingCustomer = $this->customerSyncer->sync($mockSyncStatistics, $mockClinique, $customerModel);

        // Add assertions to make sure the function behaves as expected
        $this->assertInstanceOf(\Customer::class, $resultingCustomer);
        $this->assertEquals($customerModel->email, $resultingCustomer->email);
    }
}
