<?php

namespace Unit\Accounting\Export\Exporter\Provider\Vat;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Vat\VatProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderDetailTaxRepository;
use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderInvoiceTaxRepository;
use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderSlipDetailRepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class VatProviderTest extends TestCase
{
    /**
     * @var OrderDetailTaxRepository&MockObject
     */
    private OrderDetailTaxRepository $orderDetailTaxRepository;

    /**
     * @var OrderInvoiceTaxRepository&MockObject
     */
    private OrderInvoiceTaxRepository $orderInvoiceTaxRepository;

    /**
     * @var OrderSlipDetailRepository&MockObject
     */
    private OrderSlipDetailRepository $orderSlipDetailRepository;

    private VatProvider $vatProvider;

    protected function setUp(): void
    {
        $this->orderDetailTaxRepository = $this->createMock(OrderDetailTaxRepository::class);
        $this->orderInvoiceTaxRepository = $this->createMock(OrderInvoiceTaxRepository::class);
        $this->orderSlipDetailRepository = $this->createMock(OrderSlipDetailRepository::class);

        $this->vatProvider = new VatProvider(
            $this->orderDetailTaxRepository,
            $this->orderInvoiceTaxRepository,
            $this->orderSlipDetailRepository
        );
    }

    public function testGetInvoiceAccountingLines(): void
    {
        $orderInvoice = $this->createMock(\OrderInvoice::class);
        $orderInvoice->id = 1;

        $order = $this->createMock(\Order::class);
        $order->id = 2;

        $orderDetail1 = $this->createMock(\OrderDetail::class);
        $orderDetail1->id = 100;
        $orderDetail1->total_price_tax_excl = 100;
        $orderDetail1->total_price_tax_incl = 120;

        $orderDetail2 = $this->createMock(\OrderDetail::class);
        $orderDetail2->id = 101;
        $orderDetail2->total_price_tax_excl = 50;
        $orderDetail2->total_price_tax_incl = 60;

        $this->orderDetailTaxRepository
            ->expects($this->once())
            ->method('getByOrder')
            ->with($order)
            ->willReturn(
                [
                    ['id_order_detail' => 100, 'rate' => 20.0, 'amount' => 20.0],
                    ['id_order_detail' => 101, 'rate' => 20.0, 'amount' => 10.0],
                ]
            );

        $this->orderInvoiceTaxRepository
            ->expects($this->once())
            ->method('getByOrderInvoice')
            ->with($orderInvoice)
            ->willReturn(
                [
                    ['type' => 'shipping', 'rate' => 20.0, 'amount' => 5],
                    ['type' => 'products', 'rate' => 20.0, 'amount' => 30],
                ]
            );

        $result = $this->vatProvider->getInvoiceAccountingLines($orderInvoice, $order);

        $this->assertCount(1, $result);
        $this->assertEquals('445711000', $result[0]->getAccount());
        $this->assertEquals(35, $result[0]->getCredit());
        $this->assertEquals(0, $result[0]->getDebit());
    }
}
