<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (16/08/2019 12:22).
 *
 * @deprecated
 * @see \Myvetshop\Module\Clinique\Entity\AnimalSac
 */
class AnimalSac extends ObjectModel
{
    public const TABLE = 'animal_sac';

    /**
     * @var int
     */
    public $id_animal;

    /** @var int */
    public $id_product;

    /** @var int */
    public $id_product_attribute;

    /** @var string */
    public $product_name;

    /** @var string */
    public $product_reference;

    /** @var string */
    public $product_ean13;

    /** @var int ID de commande (pour les sacs commandés sur MVS) */
    public $id_order;

    /** @var string Date de fin de consommation estimée */
    public $date_achat;

    /** @var string Date de fin de consommation estimée */
    public $date_fin_estimee;

    /** @var int Poids net en grammes */
    public $poids_net;

    /** @var int Nombre de rations estimées */
    public $nombre_rations;

    /** @var int Biais manuel appliqué au nombre de rations */
    public $nombre_rations_biais;

    /** @var string Object creation date */
    public $date_add;

    /** @var string Object last modification date */
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     *
     * @var array<mixed>
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_animal_sac',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                'id_animal' => ['type' => self::TYPE_INT],
                'id_product' => ['type' => self::TYPE_INT],
                'id_product_attribute' => ['type' => self::TYPE_INT],
                'product_name' => ['type' => self::TYPE_STRING],
                'product_reference' => ['type' => self::TYPE_STRING],
                'product_ean13' => ['type' => self::TYPE_STRING],
                'id_order' => ['type' => self::TYPE_INT],
                'date_achat' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'date_fin_estimee' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'poids_net' => ['type' => self::TYPE_INT],
                'nombre_rations' => ['type' => self::TYPE_INT],
                'nombre_rations_biais' => ['type' => self::TYPE_INT],
                'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
            ],
        ];

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function createFromOrderDetail(OrderDetail $orderDetail, Animal $animal): self
    {
        $animalSac = new self();

        $order = new Order($orderDetail->id_order);

        $animalSac->id_animal = (int) $animal->id;
        $animalSac->id_product = $orderDetail->product_id;
        $animalSac->id_product_attribute = $orderDetail->product_attribute_id;
        $animalSac->product_name = $orderDetail->product_name;
        $animalSac->product_reference = $orderDetail->product_reference;
        $animalSac->product_ean13 = $orderDetail->product_ean13;
        $animalSac->id_order = $orderDetail->id_order;
        $animalSac->date_achat = $order->invoice_date ?: $order->date_add;

        if ($animalSac->id_product_attribute) {
            // @phpstan-ignore-next-line
            $poids_net = (new Combination($animalSac->id_product_attribute))->net_weight;
        } else {
            // @phpstan-ignore-next-line
            $poids_net = (new Product($animalSac->id_product))->net_weight;
        }

        $animalSac->poids_net = (int) (\round($poids_net * 1000) * $orderDetail->product_quantity);
        $animalSac->nombre_rations = (int) \floor($animalSac->poids_net / $animal->ration);
        $animalSac->nombre_rations_biais = 0;
        $dateFinEstimee = new DateTime($animalSac->date_achat);
        $dateFinEstimee->add(new DateInterval('P' . $animalSac->nombre_rations . 'D'));
        $animalSac->date_fin_estimee = $dateFinEstimee->format('Y-m-d H:i:s');

        $animalSac->save();

        return $animalSac;
    }

    /**
     * Détermine si un produit est un sac de croquettes ou non.
     */
    public static function isCroquette(int $id_product): bool
    {
        $count = \Db::getInstance()
            ->getValue(
                'SELECT COUNT(*)'
                . ' FROM ps_feature_product fp'
                . ' INNER JOIN ps_feature_value fv ON fv.id_feature_value = fp.id_feature_value'
                . ' INNER JOIN ps_feature_value_lang fvl ON fvl.id_feature_value = fv.id_feature_value AND fvl.id_lang = 1'
                . ' WHERE id_product = ' . $id_product
                . ' AND fvl.value = "Croquettes"'
            );

        return $count > 0;
    }
}
