<?php

namespace Unit\Import\Sync\Syncer;

use Myvetshop\Module\Clinique\Import\Model\OrderModel;
use Myvetshop\Module\Clinique\Import\Sync\Syncer\OrdersSyncer;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class OrderSyncerTest extends TestCase
{
    /**
     * @var \Customer&MockObject
     */
    private \Customer $customer;

    /**
     * @var \Clinique&MockObject
     */
    private \Clinique $clinique;

    /**
     * @var \Cart&MockObject
     */
    private \Cart $cart;

    /**
     * @var \Address&MockObject
     */
    private \Address $addressInvoice;

    /**
     * @var \Address&MockObject
     */
    private \Address $addressDelivery;

    /**
     * @var \Db&MockObject
     */
    private \Db $db;

    private OrdersSyncer $ordersSyncer;

    protected function setUp(): void
    {
        $this->customer = $this->createMock(\Customer::class);
        $this->clinique = $this->createMock(\Clinique::class);
        $this->cart = $this->createMock(\Cart::class);
        $this->addressInvoice = $this->createMock(\Address::class);
        $this->addressDelivery = $this->createMock(\Address::class);
        $this->db = $this->createMock(\Db::class);

        $this->ordersSyncer = new OrdersSyncer($this->db);
    }

    public function testCreateOrders(): void
    {
        $orderModel = new OrderModel();
        $orderModel->secureKey = 'bdf9dea7c06847e6047070465b107a18';
        $orderModel->payment = 'CB Monetico';
        $orderModel->module = 'monetico1f';
        $orderModel->totalDiscounts = '5.000000';
        $orderModel->totalDiscountsTaxIncl = '4.170000';
        $orderModel->totalDiscountsTaxExcl = '5.000000';
        $orderModel->totalPaid = '65.560000';
        $orderModel->totalPaidTaxIncl = '65.560000';
        $orderModel->totalPaidTaxExcl = '54.630000';
        $orderModel->totalPaidReal = '65.560000';
        $orderModel->totalProducts = '58.800000';
        $orderModel->totalProductsWt = '70.560000';
        $orderModel->totalShipping = '0.000000';
        $orderModel->totalShippingTaxIncl = '0.000000';
        $orderModel->totalShippingTaxExcl = '0.000000';
        $orderModel->totalWrapping = '0.000000';
        $orderModel->totalWrappingTaxIncl = '0.000000';
        $orderModel->totalWrappingTaxExcl = '0.000000';
        $orderModel->carrierTaxRate = '20.000';
        $orderModel->deliveryNumber = '0';
        $orderModel->deliveryDate = new \DateTimeImmutable('0000-00-00 00:00:00');
        $orderModel->valid = true;
        $orderModel->reference = '00192895';
        $orderModel->roundMode = 2;
        $orderModel->roundType = 2;
        $orderModel->dateAdd = new \DateTimeImmutable('2024-03-26 16:10:12');
        $orderModel->dateUpd = new \DateTimeImmutable('2024-03-26 16:10:12');

        // Define the mocked methods to return predefined values
        $this->customer->id = 1;
        $this->cart->id = 1;
        $this->addressInvoice->id = 1;
        $this->addressDelivery->id = 1;

        $result = $this->ordersSyncer->fillOrder(
            $this->createMock(\Order::class),
            $this->customer,
            $this->clinique,
            $this->cart,
            $orderModel,
            $this->addressInvoice,
            $this->addressDelivery
        );

        $this->assertEquals(1, $result->id_customer);
        $this->assertEquals('5.000000', $result->total_discounts);
        $this->assertEquals('4.170000', $result->total_discounts_tax_incl);
        $this->assertEquals('5.000000', $result->total_discounts_tax_excl);
        $this->assertEquals('65.560000', $result->total_paid);
        $this->assertEquals('65.560000', $result->total_paid_tax_incl);
        $this->assertEquals('54.630000', $result->total_paid_tax_excl);
        $this->assertEquals('65.560000', $result->total_paid_real);
        $this->assertEquals('58.800000', $result->total_products);
        $this->assertEquals('70.560000', $result->total_products_wt);
        $this->assertEquals('0.000000', $result->total_shipping);
        $this->assertEquals('0.000000', $result->total_shipping_tax_incl);
        $this->assertEquals('0.000000', $result->total_shipping_tax_excl);
        $this->assertEquals('0.000000', $result->total_wrapping);
        $this->assertEquals('0.000000', $result->total_wrapping_tax_incl);
        $this->assertEquals('0.000000', $result->total_wrapping_tax_excl);
        $this->assertEquals('2024-03-26 16:10:12', $result->date_add);
        $this->assertEquals('2024-03-26 16:10:12', $result->date_upd);
    }
}
