<?php

namespace Unit\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\OrderModel;
use Myvetshop\Module\Clinique\Import\Serializer\OrderModelNormalizer;
use PHPUnit\Framework\TestCase;

class OrderModelNormalizerTest extends TestCase
{
    private OrderModelNormalizer $orderModelNormalizer;

    public function setUp(): void
    {
        $this->orderModelNormalizer = new OrderModelNormalizer();
    }

    public function testDenormalizeValidJson(): void
    {
        $rawData = [
            'email' => 'soazigleguillard@gmail.com',
            'id_order' => '192895',
            'reference' => '44908.24.00192895',
            'id_shop_group' => '1',
            'id_shop' => '1',
            'id_carrier' => '42',
            'id_lang' => '1',
            'id_customer' => '29765',
            'id_cart' => '425928',
            'id_currency' => '1',
            'id_address_delivery' => '22',
            'id_address_invoice' => '30116',
            'current_state' => '2',
            'secure_key' => 'bdf9dea7c06847e6047070465b107a18',
            'payment' => 'CB Monetico Paiement en 1 Fois [3DSecure-V2]',
            'conversion_rate' => '1.000000',
            'module' => 'monetico1f',
            'recyclable' => '0',
            'gift' => '0',
            'gift_message' => '',
            'mobile_theme' => '0',
            'shipping_number' => '',
            'total_discounts' => '5.000000',
            'total_discounts_tax_incl' => '5.000000',
            'total_discounts_tax_excl' => '4.170000',
            'total_paid' => '65.560000',
            'total_paid_tax_incl' => '65.560000',
            'total_paid_tax_excl' => '54.630000',
            'total_paid_real' => '65.560000',
            'total_products' => '58.800000',
            'total_products_wt' => '70.560000',
            'total_shipping' => '0.000000',
            'total_shipping_tax_incl' => '0.000000',
            'total_shipping_tax_excl' => '0.000000',
            'carrier_tax_rate' => '20.000',
            'total_wrapping' => '0.000000',
            'total_wrapping_tax_incl' => '0.000000',
            'total_wrapping_tax_excl' => '0.000000',
            'round_mode' => '2',
            'round_type' => '2',
            'invoice_number' => '189506',
            'delivery_number' => '0',
            'invoice_date' => '2024-03-26 16:10:12',
            'delivery_date' => '0000-00-00 00:00:00',
            'valid' => '1',
            'date_add' => '2024-03-26 16:10:12',
            'date_upd' => '2024-03-26 16:10:12',
        ];

        $normalisedData = $this->orderModelNormalizer->denormalize($rawData, OrderModel::class);

        $this->assertInstanceOf(OrderModel::class, $normalisedData);
        $this->assertEquals($rawData['email'], $normalisedData->email);
        $this->assertEquals($rawData['id_order'], $normalisedData->idOrder);
        $this->assertEquals($rawData['reference'], $normalisedData->reference);
        $this->assertEquals($rawData['id_shop_group'], $normalisedData->idShopGroup);
        $this->assertEquals($rawData['id_shop'], $normalisedData->idShop);
        $this->assertEquals($rawData['id_carrier'], $normalisedData->idCarrier);
        $this->assertEquals($rawData['id_lang'], $normalisedData->idLang);
        $this->assertEquals($rawData['id_customer'], $normalisedData->idCustomer);
        $this->assertEquals($rawData['date_add'], $normalisedData->dateAdd->format('Y-m-d H:i:s'));
        $this->assertEquals($rawData['date_upd'], $normalisedData->dateUpd->format('Y-m-d H:i:s'));
    }
}
