<?php

namespace Unit\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\CartProductModel;
use Myvetshop\Module\Clinique\Import\Serializer\CartProductModelNormalizer;
use PHPUnit\Framework\TestCase;

class CartProductModelNormalizerTest extends TestCase
{
    private CartProductModelNormalizer $normalizer;

    protected function setUp(): void
    {
        $this->normalizer = new CartProductModelNormalizer();
    }

    public function testDenormalizeShouldReturnCartProductModelOnValidData(): void
    {
        $data = [
            'email' => 'test@mail.com',
            'reference' => 'ref',
            'product_supplier_reference' => 'ref-sup',
            'id_cart' => '1',
            'id_product' => '2',
            'id_product_attribute' => '3',
            'quantity' => '5',
            'id_address_delivery' => '6',
            'id_shop' => '1',
            'date_add' => '2023-01-01 00:00:00',
        ];

        $result = $this->normalizer->denormalize($data, CartProductModel::class);

        $this->assertInstanceOf(CartProductModel::class, $result);
        $this->assertEquals('test@mail.com', $result->email);
        $this->assertEquals('ref', $result->reference);
        $this->assertEquals(1, $result->idCart);
    }

    public function testDenormalizeShouldThrowExceptionOnInvalidData(): void
    {
        $this->expectException(\Exception::class);

        // passing a non-array data
        $data = 'invalid';

        $this->normalizer->denormalize($data, CartProductModel::class);
    }
}
