<?php

namespace Unit\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\AddressModel;
use Myvetshop\Module\Clinique\Import\Serializer\AddressModelNormalizer;
use PHPUnit\Framework\TestCase;

/**
 * AddressModelNormalizerTest to validate normalization functionality
 */
class AddressModelNormalizerTest extends TestCase
{
    private AddressModelNormalizer $normalizer;

    protected function setUp(): void
    {
        $this->normalizer = new AddressModelNormalizer();
    }

    public function testDenormalize(): void
    {
        $data = [
            'email' => 'test@test.com',
            'id_address' => '1',
            'id_country' => '1',
            'id_state' => '1',
            'id_customer' => '1',
            'alias' => 'alias',
            'company' => 'Test Company',
            'lastname' => 'Doe',
            'firstname' => 'John',
            'address1' => 'Street One',
            'address2' => 'Street Two',
            'postcode' => '12345',
            'city' => 'City',
            'other' => 'Other Test',
            'phone' => '1234567890',
            'phone_mobile' => '0987654321',
            'vat_number' => 'AB12345',
            'dni' => '123456789',
            'date_add' => '2022-08-15 12:00:00',
            'date_upd' => '2022-08-15 12:00:00',
        ];
        $expected_address_model = new AddressModel();
        $expected_address_model->email = $data['email'];
        $expected_address_model->idAddress = intval($data['id_address']);
        $expected_address_model->idCountry = intval($data['id_country']);
        $expected_address_model->idState = intval($data['id_state']);
        $expected_address_model->idCustomer = intval($data['id_customer']);
        $expected_address_model->alias = $data['alias'];
        $expected_address_model->company = $data['company'];
        $expected_address_model->lastname = $data['lastname'];
        $expected_address_model->firstname = $data['firstname'];
        $expected_address_model->address1 = $data['address1'];
        $expected_address_model->address2 = $data['address2'];
        $expected_address_model->postcode = $data['postcode'];
        $expected_address_model->city = $data['city'];
        $expected_address_model->other = $data['other'];
        $expected_address_model->phone = $data['phone'];
        $expected_address_model->phoneMobile = $data['phone_mobile'];
        $expected_address_model->vatNumber = $data['vat_number'];
        $expected_address_model->dni = $data['dni'];
        $expected_address_model->dateAdd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_add'])
            ?: new \DateTimeImmutable();
        $expected_address_model->dateUpd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_upd'])
            ?: new \DateTimeImmutable();

        $address_model = $this->normalizer->denormalize($data, AddressModel::class);

        $this->assertEquals($expected_address_model, $address_model);
    }
}
