<?php

namespace Unit\Accounting\Export\Exporter\Provider\Refund;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Refund\RefundProvider;
use PHPUnit\Framework\TestCase;

class RefundProviderTest extends TestCase
{
    protected RefundProvider $refundProvider;

    protected function setUp(): void
    {
        $this->refundProvider = new RefundProvider();
    }

    public function testGetSlipAccountingLines(): void
    {
        $orderSlip = $this->getMockBuilder(\OrderSlip::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderSlip->total_products_tax_incl = 100;
        $orderSlip->total_shipping_tax_incl = 17;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $lines = $this->refundProvider->getSlipAccountingLines($orderSlip, $order);

        self::assertCount(1, $lines);
        self::assertEquals('411000000', $lines[0]->getAccount());
        self::assertEquals(117.0, $lines[0]->getCredit());
        self::assertEquals(0.0, $lines[0]->getDebit());
    }
}
