<?php

declare(strict_types=1);

if (!\defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_4_2_29(myvetshopclinique $module): bool
{
    $db = \Db::getInstance();

    $query = 'ALTER TABLE `' . _DB_PREFIX_ . \Clinique::TABLE . '`
            ADD COLUMN IF NOT EXISTS `email_delivery_notes` int(1) NOT NULL DEFAULT 1,
            ADD COLUMN IF NOT EXISTS `blockedProducts` TEXT DEFAULT NULL,
            ADD COLUMN IF NOT EXISTS `blockedProductsMessage` TEXT DEFAULT NULL';

    if (!$db->execute($query)) {
        return false;
    }

    \Configuration::updateValue(
        'MVS_CLINIQUE_BLOCKED_PRODUCT_MESSAGE',
        'Votre structure vétérinaire n’autorise pas la commande en ligne de ce produit.<br>'
        . 'Pour plus d’informations et pour vous procurer ce produit ou un produit équivalent,'
        . ' nous vous invitons à contacter votre vétérinaire.'
    );

    return true;
}
