<?php

namespace Myvetshop\Module\Clinique\Import\ImportFile;

use Myvetshop\Module\Clinique\Import\Dixptz\Serializer\CustomerModelNormalizer as DixptzCustomerModelNormalizer;
use Myvetshop\Module\Clinique\Import\Dixptz\Serializer\RewardModelNormalizer as DixptzRewardModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\CustomerModelNormalizer as KalivetCustomerModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\RewardModelNormalizer as KalivetRewardModelNormalizer;
use Myvetshop\Module\Clinique\Import\Serializer\AddressModelNormalizer;
use Myvetshop\Module\Clinique\Import\Serializer\CartProductModelNormalizer;
use Myvetshop\Module\Clinique\Import\Serializer\OrderDetailModelNormalizer;
use Myvetshop\Module\Clinique\Import\Serializer\OrderDetailTaxModelNormalizer;
use Myvetshop\Module\Clinique\Import\Serializer\OrderModelNormalizer;
use Symfony\Component\Serializer\Serializer;

class DispatchedCustomerDataFactory
{
    protected Serializer $serializer;
    protected string $dispatchFolder;

    public function __construct()
    {
        $this->serializer = new Serializer(
            [
                new AddressModelNormalizer(),
                new CartProductModelNormalizer(),
                new KalivetCustomerModelNormalizer(),
                new DixptzCustomerModelNormalizer(),
                new OrderDetailModelNormalizer(),
                new OrderDetailTaxModelNormalizer(),
                new OrderModelNormalizer(),
                new KalivetRewardModelNormalizer(),
                new DixptzRewardModelNormalizer(),
            ]
        );
        $this->dispatchFolder = sys_get_temp_dir() . DIRECTORY_SEPARATOR
            . ImportDispatcher::DISPATCH_FOLDER_NAME . DIRECTORY_SEPARATOR;
    }

    public function create(string $subDirectory): DispatchedCustomerData
    {
        return new DispatchedCustomerData(
            $this->serializer,
            $this->dispatchFolder,
            $subDirectory
        );
    }
}
