<?php

declare(strict_types=1);

require_once __DIR__ . \DIRECTORY_SEPARATOR . 'CliniquePush.php';

class WebserviceSpecificManagementNotifications implements WebserviceSpecificManagementInterface
{
    /** @var WebserviceOutputBuilderCore|null */
    protected $objOutput;

    /** @var mixed */
    protected $output;

    /** @var WebserviceRequestCore|null */
    protected $wsObject;

    public function setObjectOutput(WebserviceOutputBuilderCore $obj): self
    {
        $this->objOutput = $obj;

        return $this;
    }

    public function getObjectOutput(): ?WebserviceOutputBuilderCore
    {
        return $this->objOutput;
    }

    /**
     * @return $this
     */
    public function setWsObject(WebserviceRequestCore $obj): self
    {
        $this->wsObject = $obj;

        return $this;
    }

    public function getWsObject(): ?WebserviceRequestCore
    {
        return $this->wsObject;
    }

    public function manage(): void
    {
        $ret = [];

        if ('POST' === $_SERVER['REQUEST_METHOD']) {
            $this->registerAction();
        }

        \header('Content-Type: application/json');
        echo \json_encode([], \JSON_PRETTY_PRINT);
        exit(0);
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function registerAction(): Myvetshop\Module\Clinique\Entity\CliniquePush
    {
        /** @var WebserviceRequestCore $wsObject */
        $wsObject = $this->getWsObject();

        $id_employee = \method_exists($wsObject, 'getIdEmployee') ? $wsObject->getIdEmployee() : 0;
        $clinique = Clinique::getCliniqueByEmployeeId((int) $id_employee);

        if (!$clinique || !$clinique->id) {
            \http_response_code(500);

            throw new Exception();
        }

        $pushId = \Tools::getValue('push_id');
        $pushType = \Tools::getValue('push_type');
        $accessTokenRaw = \Tools::getValue('access_token');
        $accessToken = OAuthAccessToken::getByToken(\is_string($accessTokenRaw) ? $accessTokenRaw : '');

        if (!\is_string($pushId) || !\is_string($pushType) || !\is_string($accessTokenRaw) || !$pushId || !$pushType || !$accessToken) {
            \http_response_code(400);

            throw new Exception();
        }

        $container = \PrestaShop\PrestaShop\Adapter\SymfonyContainer::getInstance();
        \assert(null !== $container);

        /** @var \Myvetshop\Module\Clinique\Repository\CliniquePushRepository $cliniquePushRepository */
        $cliniquePushRepository = $container->get(\Myvetshop\Module\Clinique\Repository\CliniquePushRepository::class);
        /** @var \Doctrine\ORM\EntityManagerInterface $em */
        $em = $container->get(\Doctrine\ORM\EntityManagerInterface::class);

        /** @var \Myvetshop\Module\Clinique\Entity\CliniquePush|null $cliniquePush */
        $cliniquePush = $cliniquePushRepository->findOneBy(['pushId' => $pushId]);

        if (!$cliniquePush) { // création d'une clinique push à partir d'un id push
            $cliniquePush = new \Myvetshop\Module\Clinique\Entity\CliniquePush();
            $cliniquePush->pushId = $pushId;
            $cliniquePush->pushType = $pushType;
            $cliniquePush->idOauthAccessToken = (int) $accessToken->id;
            $em->persist($cliniquePush);
        } else { // Modification de l'id push
            $cliniquePush->idOauthAccessToken = (int) $accessToken->id;
        }

        $em->flush();

        return $cliniquePush;
    }

    /**
     * This must be return an array with specific values as WebserviceRequest expects.
     *
     * @return array<mixed>|string
     */
    public function getContent()
    {
        if (!$this->objOutput) {
            return [];
        }

        return $this->objOutput->getObjectRender()->overrideContent($this->output);
    }
}
