<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (14/08/2019 10:21).
 *
 * @deprecated
 * @see \Myvetshop\Module\Clinique\Entity\CustomerPush
 */
class CustomerPush extends ObjectModel
{
    public const TABLE = 'customer_push';

    /**
     * @var int
     */
    public $id_customer_push;

    /**
     * @var int
     */
    public $id_customer;

    /**
     * @var string
     */
    public $push_id;

    /**
     * @var string
     */
    public $push_type;

    /**
     * @var bool
     */
    public $is_lettre_information;

    /**
     * @var bool
     */
    public $is_commande;

    /**
     * @var bool
     */
    public $is_promos;

    /**
     * @var bool
     */
    public $is_clinique;

    /**
     * @var bool
     */
    public $is_animaux;

    /**
     * @var int
     */
    public $id_oauth_access_token;

    /**
     * @var string Object creation date
     */
    public $date_add;

    /**
     * @var string Object last modification date
     */
    public $date_upd;

    /**
     * @var bool True if address has been deleted (staying in database as deleted)
     */
    public $deleted = false;

    /**
     * @var array<string, mixed>
     *
     * @see ObjectModel::$definition
     */
    public static $definition
        = [
            'table' => self::TABLE,
            'primary' => 'id_customer_push',
            'multilang' => false,
            'multilang_shop' => false,
            'fields' => [
                'id_customer' => ['type' => self::TYPE_INT],
                'push_id' => ['type' => self::TYPE_STRING],
                'push_type' => ['type' => self::TYPE_STRING],
                'is_lettre_information' => ['type' => self::TYPE_BOOL],
                'is_commande' => ['type' => self::TYPE_BOOL],
                'is_promos' => ['type' => self::TYPE_BOOL],
                'is_clinique' => ['type' => self::TYPE_BOOL],
                'is_animaux' => ['type' => self::TYPE_BOOL],
                'id_oauth_access_token' => ['type' => self::TYPE_INT],
                'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'copy_post' => false],
                'deleted' => ['type' => self::TYPE_BOOL],
            ],
        ];

    /**
     * @throws PrestaShopDatabaseException
     */
    public static function getByPushId(string $push_id): ?int
    {
        $db = Db::getInstance(false);

        $pushes = $db->executeS(
            '
                    SELECT cp.*
                    FROM `' . _DB_PREFIX_ . self::TABLE . '` cp
                    WHERE `cp`.`push_id` = "' . $db->escape($push_id) . '"'
        );

        if (!is_array($pushes)) {
            $pushes = [];
        }

        if (0 == count($pushes)) {
            return null;
        }

        return (int) $pushes[0]['id_customer_push'];
    }

    /**
     * @param bool $auto_date
     * @param bool $null_values
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     *
     * {@inheritDoc}
     */
    public function add($auto_date = true, $null_values = false): bool
    {
        $this->date_add = date('Y-m-d H:i:s');
        $this->date_upd = date('Y-m-d H:i:s');

        return parent::add($auto_date, $null_values);
    }

    /**
     * @param false $null_values
     *
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     *
     * {@inheritDoc}
     */
    public function update($null_values = false): bool
    {
        $this->date_upd = date('Y-m-d H:i:s');

        return parent::update($null_values);
    }
}
