<?php

namespace Unit\Accounting\Export\Exporter\Provider\Shipping;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Shipping\ShippingProvider;
use PHPUnit\Framework\TestCase;

class ShippingProviderTest extends TestCase
{
    protected ShippingProvider $shippingProvider;

    protected function setUp(): void
    {
        $this->shippingProvider = new ShippingProvider();
    }

    public function testGetInvoiceAccountingLines(): void
    {
        $orderInvoice = $this->getMockBuilder(\OrderInvoice::class)
            ->disableOriginalConstructor()
            ->getMock();

        $orderInvoice->total_shipping_tax_excl = 14.0;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $lines = $this->shippingProvider->getInvoiceAccountingLines($orderInvoice, $order);

        self::assertCount(1, $lines);
        self::assertEquals('708004000', $lines[0]->getAccount());
        self::assertEquals(14.0, $lines[0]->getCredit());
        self::assertEquals(0.0, $lines[0]->getDebit());
    }

    public function testGetSlipAccountingLines(): void
    {
        $orderSlip = $this->getMockBuilder(\OrderSlip::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderSlip->total_shipping_tax_excl = 14;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $lines = $this->shippingProvider->getSlipAccountingLines($orderSlip, $order);

        self::assertCount(1, $lines);
        self::assertEquals('708004000', $lines[0]->getAccount());
        self::assertEquals(0.0, $lines[0]->getCredit());
        self::assertEquals(14.0, $lines[0]->getDebit());
    }
}
