<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table()
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\CustomerPushRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class CustomerPush
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(type="integer", name="id_customer_push", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(type="integer", name="id_customer", nullable=false)
     */
    public int $idCustomer;

    /**
     * @ORM\Column(type="string", name="push_id", nullable=false)
     */
    public string $pushId;

    /**
     * @ORM\Column(type="string", length=10, name="push_type", nullable=false)
     */
    public string $pushType;

    /**
     * @ORM\Column(type="boolean", name="is_lettre_information", nullable=true)
     */
    public ?bool $isLettreInformation = null;

    /**
     * @ORM\Column(type="boolean", name="is_commande", nullable=true)
     */
    public ?bool $isCommande = null;

    /**
     * @ORM\Column(type="boolean", name="is_promos", nullable=true)
     */
    public ?bool $isPromos = null;

    /**
     * @ORM\Column(type="boolean", name="is_clinique", nullable=true)
     */
    public ?bool $isClinique = null;

    /**
     * @ORM\Column(type="boolean", name="is_animaux", nullable=true)
     */
    public ?bool $isAnimaux = null;

    /**
     * @ORM\Column(type="integer", name="id_oauth_access_token", nullable=true)
     */
    public ?int $idOauthAccessToken = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    protected ?\DateTimeImmutable $dateAdd = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_upd", nullable=false)
     */
    protected ?\DateTimeImmutable $dateUpd = null;

    /**
     * @ORM\Column(type="boolean", name="deleted", nullable=false)
     */
    public bool $deleted = false;

    /**
     * @ORM\PrePersist()
     */
    public function prePersist(): void
    {
        $this->dateAdd = new \DateTimeImmutable();
        $this->dateUpd = new \DateTimeImmutable();
    }

    /**
     * @ORM\PreUpdate()
     */
    public function preUpdate(): void
    {
        $this->dateUpd = new \DateTimeImmutable();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateAdd(): ?\DateTimeImmutable
    {
        return $this->dateAdd;
    }

    public function getDateUpd(): ?\DateTimeImmutable
    {
        return $this->dateUpd;
    }
}
