<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\PostProcess\VatRoundCorrectorPostProcessor;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\BankChargeProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Discount\DiscountProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Payment\PaymentProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Product\ProductProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Shipping\ShippingProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Vat\VatProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderPaymentRepository;

class OrderInvoiceExporterFactory
{
    protected OrderPaymentRepository $orderPaymentRepository;
    protected PaymentProvider $paymentProvider;
    protected DiscountProvider $discountProvider;
    protected VatProvider $vatProvider;
    protected ProductProvider $productProvider;
    protected ShippingProvider $shippingProvider;
    protected BankChargeProvider $bankChargeProvider;

    protected VatRoundCorrectorPostProcessor $vatRoundCorrectorPostProcessor;

    public function __construct(
        OrderPaymentRepository $orderPaymentRepository,
        PaymentProvider $paymentProvider,
        DiscountProvider $discountProvider,
        VatProvider $vatProvider,
        ProductProvider $productProvider,
        ShippingProvider $shippingProvider,
        BankChargeProvider $bankChargeProvider,
        VatRoundCorrectorPostProcessor $vatRoundCorrectorPostProcessor
    ) {
        $this->orderPaymentRepository = $orderPaymentRepository;
        $this->paymentProvider = $paymentProvider;
        $this->discountProvider = $discountProvider;
        $this->vatProvider = $vatProvider;
        $this->productProvider = $productProvider;
        $this->shippingProvider = $shippingProvider;
        $this->bankChargeProvider = $bankChargeProvider;
        $this->vatRoundCorrectorPostProcessor = $vatRoundCorrectorPostProcessor;
    }

    public function create(): OrderInvoiceExporter
    {
        return new OrderInvoiceExporter(
            $this->orderPaymentRepository,
            [
                $this->paymentProvider,
                $this->discountProvider,
                $this->vatProvider,
                $this->productProvider,
                $this->shippingProvider,
                $this->bankChargeProvider,
            ],
            [
                $this->vatRoundCorrectorPostProcessor,
            ]
        );
    }
}
