<?php

declare(strict_types=1);

require_once __DIR__ . '/Clinique.php';

/**
 * @deprecated
 * @see \Myvetshop\Module\Clinique\Entity\MyvetshopCliniqueShipping
 */
class MyvetshopCliniqueShipping extends ObjectModel
{
    public const TABLE = 'myvetshop_clinique_shipping';

    /**
     * @var int
     */
    public $id_myvetshop_clinique;

    /**
     * @var bool
     */
    public $monday;

    /**
     * @var bool
     */
    public $tuesday;

    /**
     * @var bool
     */
    public $wednesday;

    /**
     * @var bool
     */
    public $thursday;

    /**
     * @var bool
     */
    public $friday;

    /**
     * @var bool
     */
    public $saturday;

    /**
     * @var bool
     */
    public $sunday;

    /**
     * @var array{table: string, primary: string}
     */
    public static $definition = [
        'table' => self::TABLE,
        'primary' => 'id_myvetshop_clinique_shipping',
        'fields' => [
            'id_myvetshop_clinique' => ['type' => self::TYPE_INT, 'required' => true, 'validate' => 'isInt'],
            'monday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'tuesday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'wednesday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'thursday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'friday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'saturday' => ['type' => self::TYPE_BOOL, 'required' => false],
            'sunday' => ['type' => self::TYPE_BOOL, 'required' => false],
        ],
    ];

    public function hasAllDaysDisable(): bool
    {
        $disable = true;

        foreach (self::getDays() as $day => $translate) {
            $disable = $disable && !$this->{$day};
        }

        return $disable;
    }

    public function getClinique(): Clinique
    {
        return new Clinique($this->id_myvetshop_clinique);
    }

    public static function getByCliniqueId(int $cliniqueId): self
    {
        $query = 'SELECT id_myvetshop_clinique_shipping FROM ' . _DB_PREFIX_ . self::$definition['table'] . ' WHERE id_myvetshop_clinique=' . $cliniqueId;
        $cliniqueShippingId = (int) Db::getInstance()->getValue($query);

        $cliniqueShipping = new self($cliniqueShippingId);

        if (!Validate::isLoadedObject($cliniqueShipping)) {
            $cliniqueShipping = new self();

            $cliniqueShipping->id_myvetshop_clinique = $cliniqueId;
            $cliniqueShipping->monday = false;
            $cliniqueShipping->tuesday = false;
            $cliniqueShipping->wednesday = false;
            $cliniqueShipping->thursday = false;
            $cliniqueShipping->friday = false;
            $cliniqueShipping->saturday = false;
            $cliniqueShipping->sunday = false;

            $cliniqueShipping->save();
        }

        return $cliniqueShipping;
    }

    /**
     * @return array{
     *     monday: string,
     *     tuesday: string,
     *     wednesday: string,
     *     thursday: string,
     *     friday: string,
     *     saturday: string,
     *     sunday: string
     * }
     */
    public static function getDays(): array
    {
        return [
            'monday' => 'lundi',
            'tuesday' => 'mardi',
            'wednesday' => 'mercredi',
            'thursday' => 'jeudi',
            'friday' => 'vendredi',
            'saturday' => 'samedi',
            'sunday' => 'dimanche',
        ];
    }

    public static function getDay(string $day): string
    {
        $day = \strtolower($day);
        $days = self::getDays();

        if (!\array_key_exists($day, $days)) {
            throw new Exception(\sprintf('Day %s does not exist', $day));
        }

        return $days[$day];
    }

    /**
     * @return array{
     *     monday: bool,
     *     tuesday: bool,
     *     wednesday: bool,
     *     thursday: bool,
     *     friday: bool,
     *     saturday: bool,
     *     sunday: bool
     * }
     */
    public function toArray(): array
    {
        return [
            'monday' => $this->monday,
            'tuesday' => $this->tuesday,
            'wednesday' => $this->wednesday,
            'thursday' => $this->thursday,
            'friday' => $this->friday,
            'saturday' => $this->saturday,
            'sunday' => $this->sunday,
        ];
    }

    public function toString(): string
    {
        return \implode(
            ',',
            \array_filter(
                self::getDays(),
                fn ($day) => $this->{$day},
                \ARRAY_FILTER_USE_KEY)
        );
    }

    public function add($auto_date = true, $null_values = false): bool
    {
        return parent::add($auto_date, $null_values) && parent::update();
    }

    public function update($null_values = false): bool
    {
        $result = parent::update($null_values);

        $this->getClinique()->update();

        return $result;
    }
}
