<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\ImportFile;

use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\AddressModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\CartProductModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\CustomerModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\OrderDetailModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\OrderDetailTaxModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\OrderModelNormalizer;
use Myvetshop\Module\Clinique\Import\Kalivet\Serializer\RewardModelNormalizer;
use Symfony\Component\Serializer\Serializer;

class DispatchedCustomerDataFactory
{
    protected Serializer $serializer;
    protected string $dispatchFolder;

    public function __construct()
    {
        $this->serializer = new Serializer(
            [
                new AddressModelNormalizer(),
                new CartProductModelNormalizer(),
                new CustomerModelNormalizer(),
                new OrderDetailModelNormalizer(),
                new OrderDetailTaxModelNormalizer(),
                new OrderModelNormalizer(),
                new RewardModelNormalizer(),
            ]
        );
        $this->dispatchFolder = sys_get_temp_dir() . DIRECTORY_SEPARATOR
            . ImportDispatcher::DISPATCH_FOLDER_NAME . DIRECTORY_SEPARATOR;
    }

    public function create(string $subDirectory): DispatchedCustomerData
    {
        return new DispatchedCustomerData(
            $this->serializer,
            $this->dispatchFolder,
            $subDirectory
        );
    }
}
