<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use Myvetshop\Module\Clinique\Generated\Jane\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class OrdersGetResponse200ItemProductsItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Model\\OrdersGetResponse200ItemProductsItem';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && get_class($data) === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Model\\OrdersGetResponse200ItemProductsItem';
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \Myvetshop\Module\Clinique\Generated\Jane\Model\OrdersGetResponse200ItemProductsItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('id', $data)) {
            $object->setId($data['id']);
            unset($data['id']);
        }
        if (\array_key_exists('supplier_code', $data)) {
            $object->setSupplierCode($data['supplier_code']);
            unset($data['supplier_code']);
        }
        if (\array_key_exists('name', $data)) {
            $object->setName($data['name']);
            unset($data['name']);
        }
        if (\array_key_exists('category_id', $data) && $data['category_id'] !== null) {
            $object->setCategoryId($data['category_id']);
            unset($data['category_id']);
        } elseif (\array_key_exists('category_id', $data) && $data['category_id'] === null) {
            $object->setCategoryId(null);
        }
        if (\array_key_exists('manufacturer_id', $data) && $data['manufacturer_id'] !== null) {
            $object->setManufacturerId($data['manufacturer_id']);
            unset($data['manufacturer_id']);
        } elseif (\array_key_exists('manufacturer_id', $data) && $data['manufacturer_id'] === null) {
            $object->setManufacturerId(null);
        }
        if (\array_key_exists('quantity', $data)) {
            $object->setQuantity($data['quantity']);
            unset($data['quantity']);
        }
        if (\array_key_exists('purchase_price', $data)) {
            $object->setPurchasePrice($data['purchase_price']);
            unset($data['purchase_price']);
        }
        if (\array_key_exists('total_price_tax_excl', $data)) {
            $object->setTotalPriceTaxExcl($data['total_price_tax_excl']);
            unset($data['total_price_tax_excl']);
        }
        if (\array_key_exists('total_price_tax_incl', $data)) {
            $object->setTotalPriceTaxIncl($data['total_price_tax_incl']);
            unset($data['total_price_tax_incl']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['id'] = $object->getId();
        $data['supplier_code'] = $object->getSupplierCode();
        $data['name'] = $object->getName();
        $data['category_id'] = $object->getCategoryId();
        $data['manufacturer_id'] = $object->getManufacturerId();
        $data['quantity'] = $object->getQuantity();
        $data['purchase_price'] = $object->getPurchasePrice();
        $data['total_price_tax_excl'] = $object->getTotalPriceTaxExcl();
        $data['total_price_tax_incl'] = $object->getTotalPriceTaxIncl();
        foreach ($object as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }
}
