<?php

namespace Myvetshop\Module\Clinique\Command\Centravet;

use Myvetshop\Module\Clinique\Stock\CentravetStockApiFactory;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class CentravetInstantStockCommand extends Command
{
    protected CentravetStockApiFactory $centravetStockApiFactory;

    protected function configure(): void
    {
        $this
            ->setDescription("Vérifie le stock instantané d'un produit CentraVet")
            ->addArgument('clinic_ref', InputArgument::REQUIRED, 'Code client de la clinique')
            ->addArgument('product_ref', InputArgument::REQUIRED, 'Code produit')
            ->addArgument('quantity', InputArgument::REQUIRED, 'Quantité produit');
    }

    public function __construct(
        CentravetStockApiFactory $centravetStockApiFactory
    ) {
        $this->centravetStockApiFactory = $centravetStockApiFactory;

        parent::__construct('app:centravet:instant-stock');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $api = $this->centravetStockApiFactory->create();

        if (!$api) {
            $output->writeln('API not configured');

            return 1;
        }

        if (
            $api->checkStock(
                \strval($input->getArgument('clinic_ref')),
                \strval($input->getArgument('product_ref')),
                \intval($input->getArgument('quantity')),
            )
        ) {
            $output->writeln('Produit en stock');
        } else {
            $output->writeln('Produit hors stock');
        }

        return 0;
    }
}
