<?php

declare(strict_types=1);

class HTMLTemplateInvoice extends HTMLTemplateInvoiceCore
{
    /**
     * Returns the template's HTML footer.
     */
    public function getFooter(): string
    {
        $context = \Context::getContext();
        \assert(null !== $context);

        $module = \Module::getInstanceByName('myvetshopclinique');
        if (!$module) {
            return parent::getFooter();
        }
        $container = $module->getContainer();

        if ($container && $container->has(\Myvetshop\Module\Clinique\Accounting\Legal\LegalTextGenerator::class)) {
            /** @var \Myvetshop\Module\Clinique\Accounting\Legal\LegalTextGenerator $legalTextGenerator */
            $legalTextGenerator = $container->get(\Myvetshop\Module\Clinique\Accounting\Legal\LegalTextGenerator::class);
        } else {
            // \trigger_error('Service not found LegalTextGenerator');
            $legalTextGenerator = new \Myvetshop\Module\Clinique\Accounting\Legal\LegalTextGenerator();
        }

        $legalText = $legalTextGenerator->getOrderLegalText($this->order);

        $clinique = \Clinique::getCliniqueByCarrierId((int) $this->order->id_carrier);
        if ($clinique) {
            $store = new \Store($clinique->id_store, $context->language->id);
            $legalText = str_replace(
                [
                    '{clinique.store.name}',
                ],
                [
                    $store->name,
                ],
                $legalText
            );
        }

        $shop_address = $this->getShopAddress();

        $id_shop = (int) $this->shop->id;

        $this->smarty->assign([
            'available_in_your_account' => $this->available_in_your_account,
            'shop_address' => $shop_address,
            'shop_fax' => \Configuration::get('PS_SHOP_FAX', null, null, $id_shop),
            'shop_phone' => \Configuration::get('PS_SHOP_PHONE', null, null, $id_shop),
            'shop_email' => \Configuration::get('PS_SHOP_EMAIL', null, null, $id_shop),
            'free_text' => $legalText,
        ]);

        return $this->smarty->fetch($this->getTemplate('footer'));
    }
}
