<?php

declare(strict_types=1);

require_once __DIR__ . '/reporting_init.php';

use Myvetshop\Module\Clinique\Serializer\ProductCategoryReportingSerializer;

$productCategories = \Db::getInstance()->executeS(
    'SELECT'
    . ' ' . _DB_PREFIX_ . 'category.id_category as "id"'
    . ', ' . _DB_PREFIX_ . 'category_lang.name as "name"'
    . ', ' . _DB_PREFIX_ . 'category.id_parent as "id_parent"'
    . ', ' . _DB_PREFIX_ . 'category.level_depth as "level_depth"'
    . ', ' . _DB_PREFIX_ . 'category.active as "active"'
    . ' FROM ' . _DB_PREFIX_ . 'category'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'category_lang ON ' . _DB_PREFIX_ . 'category_lang.id_category = ' . _DB_PREFIX_ . 'category.id_category'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'lang ON ' . _DB_PREFIX_ . 'category_lang.id_lang=' . _DB_PREFIX_ . 'lang.id_lang AND ' . _DB_PREFIX_ . 'lang.iso_code="fr"'
);

if (!\is_array($productCategories)) {
    $productCategories = [];
}

echo (new ProductCategoryReportingSerializer())->serialize($productCategories);
