{extends 'page.tpl'}

{block name='page_title'}
    {l s='Mes recommandations' d='Modules.Myvetshopclinique.Shop'}
{/block}

{block name='page_content_top'}

{/block}

{block name='page_content'}
    <div class="block-center">
        <div class="box">

            <h2>Recommandation nutritionnelle personnalisée pour
                votre {$recommandation->espece} {$recommandation->petname}</h2>

            <p>
                <span class="bold"><a class="text-orange" href="{$link->getPageLink('my-account', true)|escape:'html'}">Identifiez-vous</a> dès aujourd'hui sur Myvetshop pour commander vos aliments et bénéficier d'une remise supplémentaire de 5%.</span>
                <br>
                Rappel du code privilège de votre clinique : <span
                        class="text-orange bold">{$recommandation->code_clinique}</span> (à renseigner lors de votre inscription)
            </p>

            <br>

            <table class="table table-bordered">
                <tbody>
                {foreach $recommandation->products as $key => $row}
                    {assign var="product" value=$row.entity}
                    <tr>
                        <td>Aliment n°{$key +1}{if $row.months} (jusqu'à {$row.months - 1} mois){/if}
                        </td>
                        <td>
                            <img class="img-fluid card-img-top"
                                 src="{$link->getImageLink($product->link_rewrite, $recommandation->getRecoProductImageIdByIdProduct($product->id), 'home_default')|escape:'html':'UTF-8'}"
                                 alt="{$product->name|escape:'html':'UTF-8'}"
                            />
                        </td>
                        <td>{$product->name}</td>
                        <td>Ration : {$row.quantity}g/jour</td>
                        <td>
                            <a href="{$link->getProductLink($product->id)}"
                               class="btn btn-default button button-medium"><span><i class="icon-file-text-o right"></i> Fiche produit</span>
                            </a>
                        </td>
                    </tr>
                {/foreach}
                </tbody>
            </table>

            <div class="d-flex justify-content-center">
                <a href="{$link->getPageLink('my-account', true)|escape:'html'}"
                   class="btn btn btn-primary">
                    <span>M'identifier</span>
                </a>
            </div>

        </div>
    </div>
{/block}

{block name='page_footer'}

{/block}
