<?php

declare(strict_types=1);

namespace Myvetshop\Module\Clinique\Checker;

class PostalCodeChecker
{
    public const BLOCKED_POSTAL_CODE = ['971', '972', '973', '974', '975', '976', '978', '986', '987', '988'];

    public static function canDelivery(string $postalCode): bool
    {
        $postalCode = self::clean($postalCode);

        foreach (self::BLOCKED_POSTAL_CODE as $blockedPostalCode) {
            $firstsCharsPostalCode = substr($postalCode, 0, \strlen($blockedPostalCode));

            if ($firstsCharsPostalCode == $blockedPostalCode) {
                return false;
            }
        }

        return true;
    }

    private static function clean(string $postalCode): string
    {
        return str_replace(' ', '', trim($postalCode));
    }
}
