<?php

declare(strict_types=1);

require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'controllers' .
    \DIRECTORY_SEPARATOR . 'admin' . \DIRECTORY_SEPARATOR . 'AdminMyVetShopAppVetzenMaintenanceController.php';

class WebserviceSpecificManagementMaintenance implements WebserviceSpecificManagementInterface
{
    /** @var WebserviceOutputBuilderCore */
    protected $objOutput;

    /** @var mixed */
    protected $output;

    /** @var WebserviceRequestCore */
    protected $wsObject;

    /**
     * @return $this
     */
    public function setObjectOutput(WebserviceOutputBuilderCore $obj): self
    {
        $this->objOutput = $obj;

        return $this;
    }

    public function getObjectOutput(): WebserviceOutputBuilderCore
    {
        return $this->objOutput;
    }

    /**
     * @return $this
     */
    public function setWsObject(WebserviceRequestCore $obj): self
    {
        $this->wsObject = $obj;

        return $this;
    }

    public function getWsObject(): WebserviceRequestCore
    {
        return $this->wsObject;
    }

    public function manage(): void
    {
        $response = [];

        try {
            if ('GET' === $_SERVER['REQUEST_METHOD']) { // /modules/myvetshopclinique/api/maintenance?access_token=&version=
                $response =
                        [
                            'messageTitle' => Configuration::get(AdminMyVetShopAppVetzenMaintenanceController::PREFIX_NAME_COMFIG . 'MESSAGE_TITLE'),
                            'message' => Configuration::get(AdminMyVetShopAppVetzenMaintenanceController::PREFIX_NAME_COMFIG . 'MESSAGE'),
                            'messageLink' => Configuration::get(AdminMyVetShopAppVetzenMaintenanceController::PREFIX_NAME_COMFIG . 'MESSAGE_LINK'),
                            'messageLinkTitle' => Configuration::get(AdminMyVetShopAppVetzenMaintenanceController::PREFIX_NAME_COMFIG . 'MESSAGE_LINK_TITLE'),
                            'maintenanceMode' => 'on' === Configuration::get(AdminMyVetShopAppVetzenMaintenanceController::PREFIX_NAME_COMFIG . 'MAINTENANCE_MODE'),
                        ];

                if (false === $response['messageTitle']) {
                    $response['messageTitle'] = '';
                }
                if (false === $response['message']) {
                    $response['message'] = '';
                }
                if (false === $response['messageLink']) {
                    $response['messageLink'] = '';
                }
                if (false === $response['messageLinkTitle']) {
                    $response['messageLinkTitle'] = '';
                }
            } else {
                http_response_code(400);
                $response = ['success' => false, 'error' => 'La requête n\'est pas valide'];
            }
        } catch (Exception $exception) {
            http_response_code(500);
            $response = ['success' => false, 'error' => $exception->getMessage()];
        }

        header('Content-Type: application/json');
        echo json_encode($response);
        exit;
    }

    /**
     * This must be return an array with specific values as WebserviceRequest expects.
     *
     * @return array<string|int, mixed>
     */
    public function getContent(): array
    {
        return $this->objOutput->getObjectRender()->overrideContent($this->output);
    }
}
