<?php

namespace Unit\Accounting\Export\Exporter;

class OrderSlipExporterTest extends AbstractOrderSlipExporterTest
{
    public function fixtureProvider(): array
    {
        return [
            [
                [
                    'orderPayment' => [
                        ['amount' => 53.91, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 49.92,
                            'total_price_tax_incl' => 59.90,
                            'vat_amount' => 8.98,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderDiscount' => [
                        'total_tax_excl' => 4.99,
                        'total_tax_incl' => 5.99,
                        'vat_rate' => '20.000',
                    ],
                    'orderSlip' => [
                        'date' => '2023-05-09 13:27:23',
                        'invoice_number' => 372078,
                        'number' => 5376,
                        'type' => 1,
                        'products_tax_incl' => 53.91,
                        'shipping_tax_excl' => 0.0,
                        'shipping_tax_incl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                    'orderSlipDetails' => [
                        ['product_quantity' => 1, 'amount_tax_excl' => 49.92, 'amount_tax_incl' => 59.90],
                    ],
                ],
                [
                    [
                        'date' => '09/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.0,
                        'credit' => 53.91,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '7097',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 4.99,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '445711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 8.98,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '70711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 49.92,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '627',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 0.14,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.14,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => [
                        ['amount' => 30.81, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 16.59,
                            'total_price_tax_incl' => 19.89,
                            'vat_amount' => 2.93,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 12.42,
                            'total_price_tax_incl' => 14.90,
                            'vat_amount' => 2.20,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderSlip' => [
                        'date' => '2023-05-16 12:13:59',
                        'invoice_number' => 390823,
                        'number' => 5397,
                        'type' => 0,
                        'products_tax_incl' => 34.79,
                        'shipping_tax_excl' => 0.0,
                        'shipping_tax_incl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                    'orderSlipDetails' => [
                        ['product_quantity' => 1, 'amount_tax_excl' => 16.58, 'amount_tax_incl' => 19.89],
                        ['product_quantity' => 1, 'amount_tax_excl' => 12.42, 'amount_tax_incl' => 14.90],
                    ],
                ],
                [
                    [
                        'date' => '16/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.0,
                        'credit' => 34.79,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '445711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 5.79,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '70711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 29,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '627',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 0.1,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '16/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.1,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => [
                        ['amount' => 40.47, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 36.25,
                            'total_price_tax_incl' => 43.5,
                            'vat_amount' => 6.75,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderDiscount' => [
                        'total_tax_excl' => 2.53,
                        'total_tax_incl' => 3.03,
                        'vat_rate' => '20.000',
                    ],
                    'orderSlip' => [
                        'date' => '2023-01-18 11:06:45',
                        'invoice_number' => 346603,
                        'number' => 4882,
                        'type' => 1,
                        'products_tax_incl' => 40.47,
                        'shipping_tax_excl' => 0.0,
                        'shipping_tax_incl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                    'orderSlipDetails' => [
                        ['product_quantity' => 1, 'amount_tax_excl' => 36.25, 'amount_tax_incl' => 43.5],
                    ],
                ],
                [
                    [
                        'date' => '18/01/2023',
                        'account' => '4110001',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.0,
                        'credit' => 40.47,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '18/01/2023',
                        'account' => '7097',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 2.53,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '18/01/2023',
                        'account' => '445711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 6.75,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '18/01/2023',
                        'account' => '70711',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 36.25,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '18/01/2023',
                        'account' => '627',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.00,
                        'credit' => 0.11,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '18/01/2023',
                        'account' => '4000018',
                        'entitled' => 'Remboursement internet CB',
                        'debit' => 0.11,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                ],
            ],
        ];
    }
}
