<?php

namespace Unit\Accounting\Export\Exporter;

class OrderInvoiceExporterTest extends AbstractOrderInvoiceExporterTest
{
    public function fixtureProvider(): array
    {
        return [
            [
                [
                    'orderPayment' => [
                        ['amount' => 38.90, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 32.42,
                            'total_price_tax_incl' => 38.90,
                            'vat_amount' => 6.48,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-08 02:17:03',
                        'number' => 389444,
                        'paid_tax_excl' => 32.42,
                        'paid_tax_incl' => 38.90,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '08/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 38.9,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 6.48,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 32.42,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.11,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.11,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => [
                        ['amount' => 94.60, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDiscount' => ['total_tax_excl' => 5.08, 'total_tax_incl' => 6.09, 'vat_rate' => '20.000'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 33.16,
                            'total_price_tax_incl' => 39.79,
                            'vat_amount' => 6.23,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 50.75,
                            'total_price_tax_incl' => 60.9,
                            'vat_amount' => 9.54,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-08 09:06:58',
                        'number' => 389478,
                        'paid_tax_excl' => 78.83,
                        'paid_tax_incl' => 94.60,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '08/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 94.6,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '7097',
                        'entitled' => 'Vente internet',
                        'debit' => 5.08,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 15.77,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 83.91,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.27,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.27,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => [
                        ['amount' => 102.69, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 71.58,
                            'total_price_tax_incl' => 85.89,
                            'vat_amount' => 14.31,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-09 13:56:53',
                        'number' => 390144,
                        'paid_tax_excl' => 85.58,
                        'paid_tax_incl' => 102.69,
                        'shipping_tax_excl' => 14.00,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '09/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 102.69,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 17.11,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 71.58,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '7080001',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 14,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.3,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '09/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.3,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'country' => 'CH',
                    'orderPayment' => [
                        ['amount' => 81.9, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 68.25,
                            'total_price_tax_incl' => 81.9,
                            'vat_amount' => 13.65,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-05-08 13:54:27',
                        'number' => 389630,
                        'paid_tax_excl' => 68.25,
                        'paid_tax_incl' => 81.90,
                        'shipping_tax_excl' => 0.00,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '08/05/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 81.9,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 13.65,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '70713',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 68.25,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.24,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '08/05/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.24,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => [
                        ['amount' => 102.08, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 25.49,
                            'total_price_tax_incl' => 30.59,
                            'vat_amount' => 5.1,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 24.83,
                            'total_price_tax_incl' => 29.80,
                            'vat_amount' => 4.97,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 34.75,
                            'total_price_tax_incl' => 34.75,
                            'vat_amount' => 6.95,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-01-01 11:05:39',
                        'number' => 340216,
                        'paid_tax_excl' => 85.07,
                        'paid_tax_incl' => 102.08,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '01/01/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 102.08,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 17.01,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 85.07,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.3,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '01/01/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.3,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'orderPayment' => [
                        ['amount' => 107.01, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDiscount' => ['total_tax_excl' => 9.91, 'total_tax_incl' => 11.89, 'vat_rate' => '20.000'],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 99.08,
                            'total_price_tax_incl' => 118.90,
                            'vat_amount' => 19.82,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-01-19 19:54:51',
                        'number' => 347504,
                        'paid_tax_excl' => 89.17,
                        'paid_tax_incl' => 107.01,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '19/01/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 107.01,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '19/01/2023',
                        'account' => '7097',
                        'entitled' => 'Vente internet',
                        'debit' => 9.91,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '19/01/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 17.84,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '19/01/2023',
                        'account' => '70711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 99.08,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '19/01/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.31,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '19/01/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.31,
                        'payment_method' => '',
                    ],
                ],
            ],
            [
                [
                    'country' => 'CH',
                    'orderPayment' => [
                        ['amount' => 94.67, 'payment_method' => 'MyVetshop Paiements'],
                    ],
                    'orderDetails' => [
                        [
                            'total_price_tax_excl' => 27.42,
                            'total_price_tax_incl' => 32.91,
                            'vat_amount' => 5.49,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 9.13,
                            'total_price_tax_incl' => 10.95,
                            'vat_amount' => 1.83,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 14.92,
                            'total_price_tax_incl' => 17.91,
                            'vat_amount' => 2.98,
                            'vat_rate' => '20.000',
                        ],
                        [
                            'total_price_tax_excl' => 27.42,
                            'total_price_tax_incl' => 32.91,
                            'vat_amount' => 5.49,
                            'vat_rate' => '20.000',
                        ],
                    ],
                    'orderInvoice' => [
                        'date' => '2023-02-07 12:40:01',
                        'number' => 354809,
                        'paid_tax_excl' => 78.89,
                        'paid_tax_incl' => 94.67,
                        'shipping_tax_excl' => 0.0,
                        'shipping_vat_rat' => '20.000',
                    ],
                ],
                [
                    [
                        'date' => '07/02/2023',
                        'account' => '4110001',
                        'entitled' => 'Vente internet',
                        'debit' => 94.67,
                        'credit' => 0.00,
                        'payment_method' => 'MyVetshop Paiements',
                    ],
                    [
                        'date' => '07/02/2023',
                        'account' => '445711',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 15.78,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '07/02/2023',
                        'account' => '70713',
                        'entitled' => 'Vente internet',
                        'debit' => 0.0,
                        'credit' => 78.89,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '07/02/2023',
                        'account' => '627',
                        'entitled' => 'Vente internet',
                        'debit' => 0.27,
                        'credit' => 0.00,
                        'payment_method' => '',
                    ],
                    [
                        'date' => '07/02/2023',
                        'account' => '4000018',
                        'entitled' => 'Vente internet',
                        'debit' => 0.00,
                        'credit' => 0.27,
                        'payment_method' => '',
                    ],
                ],
            ],
        ];
    }
}
