<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\CartProductModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class CartProductModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return CartProductModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new CartProductModel();

        $ret->email = $data['email'];
        $ret->reference = $data['reference'];
        $ret->productSupplierReference = $data['product_supplier_reference'];
        $ret->idCart = \intval($data['id_cart']);
        $ret->idProduct = \intval($data['id_product']);
        $ret->idProductAttribute = \intval($data['id_product_attribute']);
        $ret->quantity = \intval($data['quantity']);
        $ret->idAddressDelivery = \intval($data['id_address_delivery']);
        $ret->idShop = \intval($data['id_shop']);
        $ret->dateAdd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_add'])
            ?: new \DateTimeImmutable();

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return CartProductModel::class === $type;
    }
}
