<?php

declare(strict_types=1);

/**
 * Class AdminMyVetShopCliniqueShippingController.
 *
 * @property MyvetshopCliniqueShipping $object
 */
class AdminMyVetShopCliniqueShippingController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();

        $context = Context::getContext();
        \assert(null !== $context);

        $this->bootstrap = true;
        $this->context = $context;
        $this->table = MyvetshopCliniqueShipping::$definition['table'];
        $this->className = MyvetshopCliniqueShipping::class;
        $this->position_identifier = MyvetshopCliniqueShipping::$definition['primary'];
        $this->identifier = MyvetshopCliniqueShipping::$definition['primary'];
        $this->_orderBy = MyvetshopCliniqueShipping::$definition['primary'];

        $this->loadObject();

        if (!Validate::isLoadedObject($this->object)) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminMyVetShopClinique'));
        }

        $this->_where = 'AND id_myvetshop_clinique=' . $this->object->id_myvetshop_clinique;

        $this->page_header_toolbar_title = $this->object->getClinique()->name;
    }

    public function initPageHeaderToolbar(): void
    {
        parent::initPageHeaderToolbar();

        \assert(\is_array($this->page_header_toolbar_btn));

        $this->page_header_toolbar_btn['clinique'] = [
            'href' => $this->context->link->getAdminLink('AdminMyVetShopClinique'),
            'desc' => $this->l('Retour aux cliniques'),
            'icon' => 'process-icon-back',
        ];
    }

    public function renderForm()
    {
        $this->fields_form = [
            'legend' => [
                'title' => $this->l('Modifier les jours de livraisons'),
                'icon' => 'icon-angle-double-right',
            ],
            'input' => [],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right',
                'name' => 'saveAction',
            ],
        ];

        foreach (MyvetshopCliniqueShipping::getDays() as $day => $dayTranslate) {
            $this->fields_form['input'][] = [
                'type' => 'switch',
                'label' => ucfirst($dayTranslate),
                'name' => $day,
                'required' => false,
                'is_bool' => true,
                'values' => [
                    [
                        'id' => $day . '_on',
                        'value' => 1,
                        'label' => $this->l('Enabled'),
                    ],
                    [
                        'id' => $day . '_off',
                        'value' => 0,
                        'label' => $this->l('Disabled'),
                    ],
                ],
            ];
        }

        return parent::renderForm();
    }

    public function renderView(): string
    {
        Tools::redirectAdmin($this->context->link->getAdminLink('AdminMyVetShopClinique'));

        return '';
    }

    /**
     * @return string|false
     */
    public function renderList()
    {
        Tools::redirectAdmin($this->context->link->getAdminLink('AdminMyVetShopClinique'));

        return '';
    }
}
