<?php

declare(strict_types=1);

namespace Myvetshop\Module\Clinique\Formatter;

use Symfony\Component\Translation\TranslatorInterface;

class AnimalFormatter implements \FormFormatterInterface
{
    private TranslatorInterface $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @return array<string, \FormField>
     */
    public function getFormat(): array
    {
        $fields = [];

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Nom', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('nom')
            ->setType('text')
            ->setRequired(true);

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Genre', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('id_gender')
            ->setType('select')
            ->setRequired(true)
            ->addAvailableValue(1, $this->translator->trans('Mâle', [], 'Modules.Myvetshopclinique.Shop'))
            ->addAvailableValue(2, $this->translator->trans('Femelle', [], 'Modules.Myvetshopclinique.Shop'));

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Date de naissance', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('date_naissance')
            ->setType('date');

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Espèce', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('espece')
            ->setType('select')
            ->setRequired(true)
            ->addAvailableValue('chien', $this->translator->trans('Chien', [], 'Modules.Myvetshopclinique.Shop'))
            ->addAvailableValue('chat', $this->translator->trans('Chat', [], 'Modules.Myvetshopclinique.Shop'));

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Race', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('race')
            ->setType('text');

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Robe', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('robe');

        $fields[] = (new \FormField())
            ->setLabel($this->translator->trans('Ration (g/jour)', [], 'Modules.Myvetshopclinique.Shop'))
            ->setName('ration')
            ->setType('number')
            ->addAvailableValue('comment', $this->translator->trans('Seul les chiffres sont autorisés', [], 'Modules.Myvetshopclinique.Shop'));

        $fields[] = (new \FormField())
            ->setName('token')
            ->setType('hidden');

        return \array_reduce(
            $fields,
            function (array $carry, \FormField $field): array {
                $carry[$field->getName()] = $field;

                return $carry;
            },
            []
        );
    }
}
