<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Payment;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderInvoiceLineProviderInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Model\SimpleAccountingLine;

class PaymentProvider implements OrderInvoiceLineProviderInterface
{
    public function getInvoiceAccountingLines(\OrderInvoice $orderInvoice, \Order $order): array
    {
        $ret = [];

        if ($orderInvoice->total_paid_tax_incl > 0) {
            $ret = [
                new SimpleAccountingLine(
                    '4110001',
                    0.0,
                    \round($orderInvoice->total_paid_tax_incl, 2)
                ),
            ];
        }

        return $ret;
    }

    /**
     * @param \OrderInvoice $document
     */
    public function getAccountingLines($document, \Order $order): array
    {
        return $this->getInvoiceAccountingLines($document, $order);
    }
}
