<?php

declare(strict_types=1);

class Product extends ProductCore
{
    /**
     * Indique si un produit a une vente restreinte ou non.
     *
     * @return string|false "dietetique" "rurale" ou false
     */
    public function getVenteRestreinte()
    {
        return Db::getInstance(false)
            ->getValue(
                'SELECT pfvl.value'
                . ' FROM ps_feature_product pfp'
                . ' INNER JOIN ps_feature_value pfv ON pfv.id_feature_value = pfp.id_feature_value'
                . ' INNER JOIN ps_feature_value_lang pfvl ON pfvl.id_feature_value = pfv.id_feature_value AND pfvl.id_lang = 1'
                . ' INNER JOIN ps_feature_lang pfl ON pfl.id_feature = pfv.id_feature AND pfl.id_lang = 1'
                . ' WHERE pfp.id_product = ' . (int) $this->id . ' AND pfl.name = "Achat Restreint"'
            );
    }

    public function canUserBuy(?Customer $customer = null): bool
    {
        require_once _PS_MODULE_DIR_ . 'myvetshopclinique' . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'Clinique.php';

        $venteRestreinte = $this->getVenteRestreinte();

        if (!$venteRestreinte) {
            return true;
        }

        $context = \Context::getContext();
        \assert(null !== $context);
        if (!$customer) {
            $customer = $context->customer;
        }

        // Les achats restreints ne sont pas disponibles pour les personnes non connectées
        if (!$customer->isLogged()) {
            return false;
        }
        // Si le client n'est relié à aucune clinique, alors il ne peut pas commander de produit restreint
        $clinique_id = Clinique::getCliniqueIdByGroup((int) $customer->id_default_group);
        if (!$clinique_id) {
            return false;
        }
        $clinique = new Clinique($clinique_id);

        switch ($venteRestreinte) {
            case 'rurale':
                $group = new Group($customer->id_default_group);
                if ('-pro' !== substr($group->name[$context->language->id], -4)) {
                    return false;
                }

                return (bool) $clinique->rurale;

            default:
                // Le simple fait d'avoir une clinique suffit à commander
                return true;
        }
    }
}
