<?php

declare(strict_types=1);

/**
 * Created by Aurélien RICHAUD (31/07/2019 10:02).
 */
require_once __DIR__ . \DIRECTORY_SEPARATOR . 'ApiFrontController.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'Clinique.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . '..' . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'OAuthAccessToken.php';

class MyvetshopcliniqueSsoselfModuleFrontController extends ApiFrontController
{
    public function run(): void
    {
        $this->init();

        $context = \Context::getContext();
        \assert(null !== $context);

        $customer = $this->context->customer;

        $ret = [
            'id' => $customer->id,
            'firstname' => $customer->firstname,
            'lastname' => $customer->lastname,
            'email' => $customer->email,
            'fullname' => $customer->firstname . ' ' . $customer->lastname,
            'clinique' => null,
        ];

        $id_clinique = Clinique::getCliniqueIdByGroup((int) $customer->id_default_group);

        if ($id_clinique) {
            $clinique = new Clinique($id_clinique);
            $store = new Store($clinique->id_store, $context->language->id);
            $employee = new \Employee($clinique->id_employee);

            if (!$clinique->message) {
                $clinique->message = '';
            }

            $theme = $clinique->getTheme();
            $hours = \json_decode($store->getWsHours(), true);

            $ret['clinique'] = [
                'name' => $employee->firstname . ' ' . $employee->lastname,
                'logo' => 'https://' . \Configuration::get('PS_SHOP_DOMAIN_SSL')
                    . '/img/tmp/employee_' . (int) $clinique->id_employee . '.jpg',
                'photo' => 'https://' . \Configuration::get('PS_SHOP_DOMAIN_SSL')
                    . '/img/tmp/store_' . (int) $clinique->id_store . '.jpg',
                'theme' => $theme ? 'theme' . $theme->id : '',
                'code_privilege' => $clinique->code_privilege,
                'centrale' => $clinique->centrale,
                'address1' => $store->address1,
                'address2' => $store->address2,
                'postcode' => $store->postcode,
                'city' => $store->city,
                'hours' => \implode(
                    ';',
                    \array_map(
                        function ($row) { return \is_array($row) ? ($row[0] ?? '') : ''; },
                        \is_array($hours) ? $hours : [],
                    )
                ),
                'telephone' => $store->phone,
                'url_rendez_vous' => $clinique->url_rendez_vous,
                'jours_livraison' => $clinique->getShipping()->toString(),
                // @phpstan-ignore-next-line
                'website' => $store->website,
                'message' => $clinique->message,
                'veterinaires' => [],
            ];

            foreach ($clinique->getVeterinaires() as $veterinaire) {
                $ret['clinique']['veterinaires'][] = $veterinaire->toArray();
            }
        }

        echo \json_encode($ret, \JSON_PRETTY_PRINT);
    }
}
