<?php

namespace Unit\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\OrderInvoiceExporterFactory;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\PostProcess\VatRoundCorrectorPostProcessor;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\BankChargeProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\Computer\BankChargeComputerFactory;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Discount\DiscountProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Payment\PaymentProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Product\ProductProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Shipping\ShippingProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Vat\VatProvider;

/**
 * @extends AbstractDocumentExporterTest<\OrderInvoice>
 */
abstract class AbstractOrderInvoiceExporterTest extends AbstractDocumentExporterTest
{
    protected function setUp(): void
    {
        parent::setUp();

        $paymentProvider = new PaymentProvider();
        $discountProvider = new DiscountProvider();
        $vatProvider = new VatProvider(
            $this->orderDetailTaxRepository,
            $this->orderInvoiceTaxRepository,
            $this->orderSlipDetailRepository
        );
        $productProvider = new ProductProvider(
            $this->countryRepository,
            $this->invoiceAddressRepository,
            $this->orderDetailRepository,
            $this->orderDetailTaxRepository,
            $this->orderSlipDetailRepository
        );
        $shippingProvider = new ShippingProvider();
        $bankChargeProvider = new BankChargeProvider(
            new BankChargeComputerFactory(),
            $this->orderPaymentRepository
        );

        $vatPostProcessor = new VatRoundCorrectorPostProcessor();

        $factory = new OrderInvoiceExporterFactory(
            $paymentProvider,
            $discountProvider,
            $vatProvider,
            $productProvider,
            $shippingProvider,
            $bankChargeProvider,
            $vatPostProcessor
        );

        $this->exporter = $factory->create();
    }
}
