<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Model;

class ExportLine
{
    protected \DateTimeImmutable $date;

    protected string $journal;

    protected string $account;

    protected string $entitled;

    protected string $docNumber;

    protected float $debit;

    protected float $credit;

    public function __construct(
        \DateTimeImmutable $date,
        string $journal,
        string $account,
        string $entitled,
        string $docNumber,
        float $debit,
        float $credit
    ) {
        $this->date = $date;
        $this->journal = $journal;
        $this->account = $account;
        $this->entitled = $entitled;
        $this->docNumber = $docNumber;
        $this->debit = $debit;
        $this->credit = $credit;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getDate(): \DateTimeImmutable
    {
        return $this->date;
    }

    /**
     * @return string
     */
    public function getJournal(): string
    {
        return $this->journal;
    }

    /**
     * @return string
     */
    public function getAccount(): string
    {
        return $this->account;
    }

    /**
     * @return string
     */
    public function getEntitled(): string
    {
        return $this->entitled;
    }

    /**
     * @return string
     */
    public function getDocNumber(): string
    {
        return $this->docNumber;
    }

    /**
     * @return float
     */
    public function getDebit(): float
    {
        return $this->debit;
    }

    /**
     * @return float
     */
    public function getCredit(): float
    {
        return $this->credit;
    }

    public static function createFromSimpleLine(
        SimpleAccountingLineInterface $accountingLine,
        \DateTimeImmutable $documentDate,
        string $documentId,
        string $entitled
    ): self {
        return new ExportLine(
            $documentDate,
            'VE',
            $accountingLine->getAccount(),
            $entitled,
            $documentId,
            $accountingLine->getDebit(),
            $accountingLine->getCredit()
        );
    }
}
