<?php

class HTMLTemplateOrderSlip extends HTMLTemplateOrderSlipCore
{
    /**
     * Returns the template's HTML footer.
     */
    public function getFooter(): string
    {
        $context = \Context::getContext();
        \assert(null !== $context);

        $module = \Module::getInstanceByName('myvetshopclinique');
        if (!$module) {
            return parent::getFooter();
        }

        $container = $module->getContainer();
        if (null === $container) {
            return parent::getFooter();
        }

        /** @var \Myvetshop\Module\Clinique\Accounting\Legal\LegalTextGenerator $legalTextGenerator */
        $legalTextGenerator = $container->get(\Myvetshop\Module\Clinique\Accounting\Legal\LegalTextGenerator::class);

        $legalText = $legalTextGenerator->getOrderLegalText($this->order);

        $clinique = \Clinique::getCliniqueByCarrierId((int) $this->order->id_carrier);
        if ($clinique) {
            $store = new \Store($clinique->id_store, $context->language->id);
            $legalText = str_replace(
                [
                    '{clinique.store.name}',
                ],
                [
                    $store->name,
                ],
                $legalText
            );
        } else {
            $legalText = str_replace(
                [
                    '{clinique.store.name}',
                ],
                [
                    '',
                ],
                $legalText
            );
        }

        $shop_address = $this->getShopAddress();

        $id_shop = (int) $this->shop->id;

        $this->smarty->assign([
            'available_in_your_account' => $this->available_in_your_account,
            'shop_address' => $shop_address,
            'shop_fax' => \Configuration::get('PS_SHOP_FAX', null, null, $id_shop),
            'shop_phone' => \Configuration::get('PS_SHOP_PHONE', null, null, $id_shop),
            'shop_email' => \Configuration::get('PS_SHOP_EMAIL', null, null, $id_shop),
            'free_text' => $legalText,
        ]);

        return $this->smarty->fetch($this->getTemplate('footer'));
    }
}
