<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\PostProcess\VatRoundCorrectorPostProcessor;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\BankCharge\BankChargeProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Discount\DiscountProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Product\ProductProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Refund\RefundProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Shipping\ShippingProvider;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Vat\VatProvider;

class OrderSlipExporterFactory
{
    protected RefundProvider $refundProvider;
    protected DiscountProvider $discountProvider;
    protected VatProvider $vatProvider;
    protected ProductProvider $productProvider;
    protected ShippingProvider $shippingProvider;
    protected BankChargeProvider $bankChargeProvider;
    protected VatRoundCorrectorPostProcessor $vatRoundCorrectorPostProcessor;

    public function __construct(
        RefundProvider $refundProvider,
        DiscountProvider $discountProvider,
        VatProvider $vatProvider,
        ProductProvider $productProvider,
        ShippingProvider $shippingProvider,
        BankChargeProvider $bankChargeProvider,
        VatRoundCorrectorPostProcessor $vatRoundCorrectorPostProcessor
    ) {
        $this->refundProvider = $refundProvider;
        $this->discountProvider = $discountProvider;
        $this->vatProvider = $vatProvider;
        $this->productProvider = $productProvider;
        $this->shippingProvider = $shippingProvider;
        $this->bankChargeProvider = $bankChargeProvider;
        $this->vatRoundCorrectorPostProcessor = $vatRoundCorrectorPostProcessor;
    }

    public function create(): OrderSlipExporter
    {
        return new OrderSlipExporter(
            [
                $this->refundProvider,
                $this->discountProvider,
                $this->vatProvider,
                $this->productProvider,
                $this->shippingProvider,
                $this->bankChargeProvider,
            ],
            [
                $this->vatRoundCorrectorPostProcessor,
            ]
        );
    }
}
