<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Clinic;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\ClinicModel;

class ClinicImportFileProvider
{
    /**
     * @var list<ClinicModel>
     */
    protected ?array $clinics = null;

    /**
     * @return resource
     */
    public function open()
    {
        $ret = \fopen('/tmp/cliniques.csv', 'r');

        if (!$ret) {
            throw new \Exception("Can't open /tmp/cliniques.csv file");
        }

        return $ret;
    }

    /**
     * @return list<ClinicModel>
     */
    public function getClinics(): array
    {
        if (null === $this->clinics) {
            $csv = $this->open();

            // Skip 2 first lines
            \fgetcsv($csv, 0, ';');
            \fgetcsv($csv, 0, ';');

            $header = [
                'code_privilege',
                'code_alcyon_kalivet',
                'nom_kalivet',
                'code_postal',
                'ville',
                'code_alycon_myvetshop',
                'name',
                'entrepot',
                'jours_livraison',
                'livraison_lundi',
                'livraison_mardi',
                'livraison_mercredi',
                'livraison_jeudi',
                'livraison_vendredi',
                'livraison_samedi',
                'horaires_lundi',
                'horaires_mardi',
                'horaires_mercredi',
                'horaires_jeudi',
                'horaires_vendredi',
                'horaires_samedi',
                'email',
            ];

            $this->clinics = [];

            while ($line = \fgetcsv($csv, 0, ';')) {
                $row = \array_combine($header, $line);

                \assert(false !== $row);

                $model = new ClinicModel();
                $model->codePrivilege = $row['code_privilege'] ?? '';
                $model->codeAlcyonKalivet = $row['code_alcyon_kalivet'] ?? '';
                $model->nomKalivet = $row['nom_kalivet'] ?? '';
                $model->codePostal = $row['code_postal'] ?? '';
                $model->ville = $row['ville'] ?? '';
                $model->codeAlcyonMyvetshop = $row['code_alycon_myvetshop'] ?? '';
                $model->name = $row['name'] ?? '';
                $model->entrepot = $row['entrepot'] ?? '';
                $model->livraisonLundi = !empty($row['livraison_lundi']);
                $model->livraisonMardi = !empty($row['livraison_mardi']);
                $model->livraisonMercredi = !empty($row['livraison_mercredi']);
                $model->livraisonJeudi = !empty($row['livraison_jeudi']);
                $model->livraisonVendredi = !empty($row['livraison_vendredi']);
                $model->livraisonSamedi = !empty($row['livraison_samedi']);
                $model->email = $row['email'] ?? '';

                if (empty($model->codePrivilege)) {
                    continue;
                }

                $this->clinics[] = $model;
            }

            \fclose($csv);
        }

        return $this->clinics;
    }
}
