<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Exporter;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\PostProcess\ExportPostProcessorInterface;
use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\OrderSlipLineProviderInterface;

/**
 * @extends AbstractDocumentExporter<\OrderSlip>
 */
class OrderSlipExporter extends AbstractDocumentExporter
{
    protected function getDocumentDate($document): \DateTimeImmutable
    {
        $slipDate = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', (string) $document->date_add);
        if (!$slipDate) {
            throw new \Exception('Invalid invoice date');
        }

        return $slipDate;
    }

    protected function getDocumentReference($document, \Order $order): string
    {
        return $order->invoice_number . '-' . $document->id;
    }

    /**
     * @param list<OrderSlipLineProviderInterface> $providers
     * @param list<ExportPostProcessorInterface> $postProcessors
     */
    public function __construct(
        array $providers,
        array $postProcessors
    ) {
        $this->providers = $providers;
        $this->postProcessors = $postProcessors;
        $this->entitled = 'Remboursement internet CB';
    }

    public function export($document, \Order $order): array
    {
        if ((int) $document->id_order !== (int) $order->id) {
            throw new \LogicException('OrderSlip#' . $document->id . ' and Order#' . $order->id . " don't match");
        }

        if (\property_exists($document, 'has_voucher') && $document->has_voucher) {
            throw new \Exception('Voucher Order Slip are not supported');
            /*
             * // Plus utilisé, gardé pour rétrocompatibilité sur les anciens avoirs

            // Remboursement sous forme d'un bon de réduction
            // 1 - Montant payé par le client [4110001]
            $ret[] = [
            'date' => $orderSlipDate->format('d/m/Y'),
            'journal' => 'VE',
            'compte' => '4110001',
            'intitule' => 'Remboursement internet BR',
            'nofacture' => $this->orderInvoice->number . '-' . $orderSlip->id,
            'debit' => 0.00,
            'credit' => \round($orderSlip->total_products_tax_incl, 2),
            ];

            // 3 - TVA Totale réglée par le client [445711]
            $ret[] = [
            'date' => $orderSlipDate->format('d/m/Y'),
            'journal' => 'VE',
            'compte' => '445711',
            'intitule' => 'Remboursement internet BR',
            'nofacture' => $this->orderInvoice->number . '-' . $orderSlip->id,
            'debit' => \round($orderSlip->total_products_tax_incl - $orderSlip->total_products_tax_excl, 2),
            'credit' => 0.00,
            ];

             * Mettre à jour les comptes :
             * 70711 : Ventes internet 20% (celui qu’on utilise actuellement)
            7071101 : Ventes internet 5,5%
            7071102 : Ventes internet 10%

            70713 : Ventes internet SUISSE autre que UE 20% (celui qu’on utilise actuellement)
            7071301 : Ventes internet SUISSE autre que UE 5,5%
            7071302 : Ventes internet SUISSE autre que UE 10%

            // 4 - Total produits HT réglé [70711, 70112, 70713]
            $ret[] = [
                'date' => $orderSlipDate->format('d/m/Y'),
                'journal' => 'VE',
                'compte' => self::PR_BY_CTRY[$this->addressInvoice->id_country] ?? 70112,
                'intitule' => 'Remboursement internet BR',
                'nofacture' => $this->orderInvoice->number . '-' . $orderSlip->id,
                'debit' => \round($orderSlip->total_products_tax_excl, 2),
                'credit' => 0.00,
            ];
             */
        }

        return parent::export($document, $order);
    }

    /*
        public function export(): array
        {
            return \array_merge(
                $this->exportRefundLines(),
                $this->exportDiscountLines(),
                $this->exportVatLines(),
                $this->exportProductLines(),
                $this->exportShippingLines(),
                $this->exportBankCommissionLines(),
            );
        }
    */
    public function supports($document): bool
    {
        return $document instanceof \OrderSlip;
    }
}
