<?php

declare(strict_types=1);

use Myvetshop\Module\Clinique\Serializer\ClinicReportingSerializer;

require_once __DIR__ . '/reporting_init.php';

$clinics = \Db::getInstance()->executeS(
    'SELECT'
    . ' ' . _DB_PREFIX_ . Clinique::TABLE . '.id_' . Clinique::TABLE . ' as "id"'
    . ', ' . _DB_PREFIX_ . Clinique::TABLE . '.code_privilege as "code_privilege"'
    . ', ' . _DB_PREFIX_ . 'store_lang.name as "name"'
    . ', ' . _DB_PREFIX_ . 'store_lang.address1 as "address1"'
    . ', ' . _DB_PREFIX_ . 'store_lang.address2 as "address2"'
    . ', ' . _DB_PREFIX_ . 'store.postcode as "postcode"'
    . ', ' . _DB_PREFIX_ . 'store.city as "city"'
    . ', ' . _DB_PREFIX_ . Clinique::TABLE . '.deleted as "deleted"'
    . ' FROM ' . _DB_PREFIX_ . Clinique::TABLE
    . ' INNER JOIN ' . _DB_PREFIX_ . 'store ON ' . _DB_PREFIX_ . 'store.id_store=' . _DB_PREFIX_ . Clinique::TABLE . '.id_store'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'store_lang ON ' . _DB_PREFIX_ . 'store_lang.id_store=' . _DB_PREFIX_ . Clinique::TABLE . '.id_store'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'lang ON ' . _DB_PREFIX_ . 'store_lang.id_lang=' . _DB_PREFIX_ . 'lang.id_lang AND ' . _DB_PREFIX_ . 'lang.iso_code="fr"'
);

if (!\is_array($clinics)) {
    $clinics = [];
}

echo (new ClinicReportingSerializer())->serialize($clinics);
