<?php

namespace Unit\Accounting\Export\Repository;

use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderPaymentRepository;
use PHPUnit\Framework\TestCase;

class OrderPaymentRepositoryTest extends TestCase
{
    public function testGetByOrderInvoice(): void
    {
        $db = $this->getMockBuilder(\Db::class)
            ->disableOriginalConstructor()
            ->getMock();

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order->id = 1;
        $order->reference = 'KNVMOCJRD';

        $repository = new OrderPaymentRepository($db);

        $db
            ->method('executeS')
            ->with('SELECT poip.id_order_invoice, poip.id_order, pop.*'
                . ' FROM `pstest_order_invoice_payment` poip'
                . ' INNER JOIN `pstest_order_payment` pop ON pop.id_order_payment = poip.id_order_payment'
                . ' WHERE poip.id_order IN (1)'
            )
            ->willReturn([
                [
                    'id_order' => 1,
                    'id_order_invoice' => 5,
                    'order_reference' => $order->reference,
                ],
            ]);

        // Preload objects
        $repository->preload([$order]);

        $orderInvoice = $this->getMockBuilder(\OrderInvoice::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderInvoice->id = 5;

        $orderPayments = $repository->getByOrderInvoice($orderInvoice);

        self::assertCount(1, $orderPayments);
        self::assertEquals($order->reference, $orderPayments[0]->order_reference);
    }
}
