<?php

declare(strict_types=1);

class Search extends SearchCore
{
    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getListSpecies(): array
    {
        return self::getValuesFeature('Espèces');
    }

    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getListTypesOfFood(): array
    {
        return self::getValuesFeature('Type d\'alimentation');
    }

    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getListConditioning(): array
    {
        return self::getValuesFeature('Conditionnement');
    }

    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getListProductRange(): array
    {
        return self::getValuesFeature('Gamme');
    }

    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getListDisease(): array
    {
        return self::getValuesFeature('Maladie');
    }

    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getListProductSupplier(): array
    {
        return self::getValuesFeature('Fournisseur');
    }

    /**
     * @return array<array<string, mixed>>
     *
     * @throws PrestaShopDatabaseException
     */
    public static function getValuesFeature(string $featureName): array
    {
        $db = Db::getInstance();

        $query = '
        SELECT feature_value.id_feature, feature_value_lang.value, feature_value.id_feature_value
        FROM `ps_feature_value` as feature_value
        INNER JOIN `ps_feature_lang` as feature_lang on feature_lang.id_feature =  feature_value.id_feature
        INNER JOIN `ps_feature_value_lang` as feature_value_lang on feature_value_lang.id_feature_value =  feature_value.id_feature_value
        WHERE feature_lang.name = "' . $db->escape($featureName) . '"
        ';

        $result = $db->executeS($query);

        if (!is_array($result)) {
            $result = [];
        }

        return $result;
    }
}
