<?php

declare(strict_types=1);

class CartController extends CartControllerCore
{
    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    protected function processChangeProductInCart(): void
    {
        if (!$this->context->customer->isLogged()) {
            $this->errors[] = $this->trans(
                'Vous devez vous connecter pour ajouter un produit au panier',
                [],
                'Modules.Myvetshopclinique.Shop'
            );

            return;
        }

        require_once _PS_MODULE_DIR_ . 'myvetshopclinique'
            . \DIRECTORY_SEPARATOR . 'class'
            . \DIRECTORY_SEPARATOR . 'LimitedNumberOfProductByOrder.php';
        $price = Product::getPriceStatic(
            (int) $this->id_product,
            false,
            (int) $this->id_product_attribute,
            6,
            null,
            false
        );
        if ($price <= 0.05) {
            $this->errors[] = $this->trans(
                'Ce produit n\'est pas disponible car son prix présente une erreur.'
                . ' Vous ne pouvez pas le commander actuellement.',
                [],
                'Modules.Myvetshopclinique.Shop'
            );
        }
        $product = new Product(\intval(Tools::getValue('id_product')));
        $quantity = \intval(Tools::getValue('qty'));
        $op = Tools::getValue('op', 'up');
        if ('up' === $op && $product->id) {
            if (!LimitedNumberOfProductByOrder::canBuyProduct($this->context->cart, $product, $quantity)) {
                $this->errors[] = $this->trans('Impossible d’ajouter cette référence dans votre panier.', [], 'Modules.Myvetshopclinique.Shop');
            }
        }
        /**
         * Empêche l'ajout des produits dont les achats sont restreints.
         */
        $product = new Product($this->id_product, true, $this->context->language->id);

        if (!$product->canUserBuy($this->context->customer)) {
            switch ($product->getVenteRestreinte()) {
                case 'dietetique':
                    $this->errors[] = $this->trans(
                        "Merci d'avoir voulu commander ce produit.<br><br>Pour toute commande de produit"
                        . ' diététique, <br>vous devez avoir un code privilège composé <br>de 3 lettres et 3'
                        . ' chiffres, fourni par votre vétérinaire.<br><br>Pour pouvoir compléter cette information,'
                        . ' <br>veuillez cliquer sur le bouton « Mon compte » <br>ci-dessous ou aller vers'
                        . ' « Nos vétérinaires »',
                        [],
                        'Modules.Myvetshopclinique.Shop'
                    );
                    break;
                case 'rurale':
                    $this->errors[] = $this->trans(
                        "Merci d'avoir voulu commander ce produit.<br><br>Pour toute commande de produit"
                        . ' rural, <br>vous devez avoir un code privilège composé <br>de 3 lettres et 3'
                        . ' chiffres, fourni par votre vétérinaire et que votre clinique autorise la vente de tels'
                        . ' produits.<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le'
                        . ' bouton « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »',
                        [],
                        'Modules.Myvetshopclinique.Shop'
                    );
                    break;
                default:
                    $this->errors[] = $this->trans(
                        "Merci d'avoir voulu commander ce produit.<br><br>Ce produit n'est pas disponible"
                        . " à la vente sans code privilège et si votre clinique n'a pas donné l'autorisation."
                        . '<br><br>Pour pouvoir compléter cette information, <br>veuillez cliquer sur le bouton'
                        . ' « Mon compte » <br>ci-dessous ou aller vers « Nos vétérinaires »',
                        [], '
                        Modules.Myvetshopclinique.Shop'
                    );
            }
        }
        if (!$product->id || !$product->active || !$product->checkAccess($this->context->cart->id_customer)) {
            $this->errors[] = $this->trans(
                'This product is no longer available.', [],
                'Shop.Notifications.Error'
            );

            return;
        }
        if (0 == count($this->errors)) {
            parent::processChangeProductInCart();
        }
    }

    public function initContent(): void
    {
        if ('show' === Tools::getValue('action')) {
            if (!$this->context->customer->isLogged()) {
                Tools::redirect('index.php');
            } elseif (true === $this->areProductsAvailable()) {
                Tools::redirect((new Link())->getPageLink('order'));
            }
        }

        parent::initContent();
    }
}
